<?php
// Enable error reporting (for debugging)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
$servername = "localhost";
$username = "uofsedu_Rmn";
$password = "Almnsi@27";
$dbname = "uofsedu_merowe_db";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Initialize variables with GET parameters as fallback
$reference = isset($_GET['reference']) ? $_GET['reference'] : '';
$amount = "";
$name = "";
$record_found = false;

// Fetch data from database if reference is provided
if (!empty($reference)) {
    $sql = "SELECT name, amount FROM other_fees WHERE reference = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("s", $reference);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $stmt->bind_result($db_name, $db_amount);
            $stmt->fetch();
            
            // Use database values
            $name = $db_name;
            $amount = $db_amount;
            $record_found = true;
        } else {
            // If not found in database, use GET parameters as fallback
            $name = isset($_GET['name']) ? $_GET['name'] : '';
            $amount = isset($_GET['amount']) ? $_GET['amount'] : '';
        }
        $stmt->close();
    }
}

$conn->close();

// If no reference provided or no data found, check if GET parameters exist
if (!$record_found && empty($name)) {
    $name = isset($_GET['name']) ? $_GET['name'] : '';
    $amount = isset($_GET['amount']) ? $_GET['amount'] : '';
}
?>

<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmation</title>
    <style>
        body {
            font-family: Al-Hadith2;
            background-color: #f3f4f6; /* Light gray background */
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh; /* Full height for centering */
            margin: 0;
        }
        .confirmation-card {
            max-width: 400px;
            padding: 20px;
            border-radius: 8px;
            background-color: #d4edda; /* Light green background */
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); /* Shadow for card effect */
            text-align: center;
            border: 2px solid #28a745; /* Green border */
        }
        h2 {
            color: #155724; /* Darker green for the title */
            margin: 10px 0;
        }
        p {
            margin: 10px 0;
            color: #333; /* Dark gray for text */
        }
        .checkmark {
            font-size: 50px;
            color: #28a745; /* Green color for checkmark */
            margin: 10px 0;
        }
        .qr-code {
            margin: 20px 0;
        }
        button {
            width: 100%; /* Full width */
            margin: 10px 0; /* Space between buttons */
            padding: 10px 0; /* Vertical padding */
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.3s; /* Transition effects */
            text-align: center;
            color: white; /* Text color */
        }
        #downloadBtn {
            background: linear-gradient(45deg, #28a745, #218838); /* Green gradient */
        }
        #shareBtn {
            background: linear-gradient(45deg, #007bff, #0056b3); /* Blue gradient */
        }
        #completeOrderBtn {
            background: linear-gradient(45deg, #ffc107, #e0a800); /* Yellow gradient */
        }
        #goBackBtn {
            background: linear-gradient(45deg, #dc3545, #c82333); /* Red gradient */
        }
        button:hover {
            transform: scale(1.05); /* Scale effect on hover */
        }
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>
<body>
    <div class="confirmation-card">
        <div class="checkmark">✔️</div>
        <h2> :تم إنشاء الطلب بنجاح</h2>
        <p>: الرقم المرجعي لسداد الرسوم هو</p>
        <p><strong><?php echo htmlspecialchars($reference); ?></strong></p>
         <p>   يمكنك إستخدام الرقم للسداد عبر  البنك الاسلامي السوداني</p>
         <p>: جملة المبغ</p>
        <p><strong><?php echo htmlspecialchars($amount); ?></strong></p>
        <p>: إسم مقدم الطلب</p>
        <p><strong><?php echo htmlspecialchars($name); ?></strong></p>
        <div class="qr-code">
            <img id="qrCode" src="" alt="QR Code">
        </div>
        
        <button id="downloadBtn">Download QR Code</button>
        <button id="shareBtn">Share QR Code</button>
        
        <button id="completeOrderBtn">Go to Complete your Order</button>
        <button id="goBackBtn">Go Back</button>
    </div>

    <script>
        $(document).ready(function() {
            const reference = "<?php echo htmlspecialchars($reference); ?>";
            const name = "<?php echo htmlspecialchars($name); ?>";
            const amount = "<?php echo htmlspecialchars($amount); ?>";
            const qrCodeData = `Reference: ${reference}, Name: ${name}, Amount: ${amount}`;
            const qrCodeUrl = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(qrCodeData)}&size=150x150`;
            $('#qrCode').attr('src', qrCodeUrl);

            // Download QR Code functionality
            $('#downloadBtn').on('click', function() {
                const link = document.createElement('a');
                link.href = qrCodeUrl;
                link.download = `QR_Code_${reference}.png`; // Name for the downloaded file
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });

            // Share QR Code functionality
            $('#shareBtn').on('click', function() {
                const shareText = `Scan this QR Code to make a payment!\nReference: ${reference}\nName: ${name}\nAmount: ${amount}`;
                const shareUrl = qrCodeUrl; // URL of the QR Code

                // Create share link (for example, using WhatsApp)
                const whatsappUrl = `https://api.whatsapp.com/send?text=${encodeURIComponent(shareText + '\n' + shareUrl)}`;
                window.open(whatsappUrl, '_blank');
            });

            // Navigate to Complete your Order
            $('#completeOrderBtn').on('click', function() {
                window.open('https://cer.uofs.edu.sd/%d8%a5%d8%b3%d8%aa%d8%ae%d8%b1%d8%a7%d8%ac-%d8%B4%d9%87%d8%a7%d8%af%d8%a9/', '_blank');
            });

            // Go Back functionality
            $('#goBackBtn').on('click', function() {
                window.location.href = 'https://mpay.uofs.edu.sd/'; // Replace with your form page
            });
        });
    </script>
</body>
</html>