<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Other Fees</title>
    <style>
        /* Reset some default styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* Body Styling */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        /* Container for the form */
        .form-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 100%;
        }

        /* Styling the form elements */
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin-bottom: 5px;
            color: #555;
        }

        input[type="text"],
        input[type="number"],
        select,
        input[type="submit"] {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            width: 100%;
        }

        input[type="submit"] {
            background-color: #28a745;
            color: #fff;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        input[type="submit"]:hover {
            background-color: #218838;
        }

        input[readonly] {
            background-color: #e9ecef; /* Give a light gray background to indicate it's readonly */
            cursor: not-allowed; /* Change the cursor to indicate that it's not editable */
        }

        /* Responsive media queries */
        @media (max-width: 768px) {
            .form-container {
                padding: 15px;
            }

            input[type="text"],
            input[type="number"] {
                font-size: 14px;
            }
        }

        @media (max-width: 480px) {
            h2 {
                font-size: 20px;
            }

            input[type="submit"] {
                font-size: 14px;
                padding: 8px;
            }
        }
    </style>

    <script>
        // JavaScript function to update the amount based on the selected dropdown option
        function updateAmount() {
            var dropdown = document.getElementById("fee_choice");
            var amountField = document.getElementById("amount");

            // Define amounts for each choice
            var amounts = {
                "Option 1": 100,
                "Option 2": 200,
                "Option 3": 300,
                "Option 4": 400,
                "Option 5": 500,
                "Option 6": 600
            };

            // Get the selected value from the dropdown
            var selectedOption = dropdown.options[dropdown.selectedIndex].text;

            // Set the amount field value based on the selected option
            amountField.value = amounts[selectedOption] || 0;
        }
    </script>
</head>
<body>
    <div class="form-container">
        <h2>Insert Other Fees</h2>
        <form action="insert_data.php" method="post">
            <label for="name">Name:</label>
            <input type="text" id="name" name="name" required>

            <label for="phone_number">Phone Number:</label>
            <input type="text" id="phone_number" name="phone_number" required>

            <label for="fee_choice">Select a Fee Type:</label>
            <select id="fee_choice" name="fee_choice" onchange="updateAmount()" required>
                <option value="" disabled selected>Select Fee Type</option>
                <option value="1">Option 1</option>
                <option value="2">Option 2</option>
                <option value="3">Option 3</option>
                <option value="4">Option 4</option>
                <option value="5">Option 5</option>
                <option value="6">Option 6</option>
            </select>

            <label for="reference">Reference:</label>
            <input type="text" id="reference" name="reference">

            <label for="amount">Amount:</label>
            <!-- Readonly amount field to prevent user modification -->
            <input type="text" id="amount" name="amount" readonly>

            <input type="submit" value="Submit">
        </form>
    </div>
</body>
</html>
