<?php
// Database connection
$servername = "localhost";
$username = "uofsedu_Rmn";
$password = "Almnsi@27";
$dbname = "uofsedu_merowe_db";

$conn = new mysqli($servername, $username, $password, $dbname);
$conn->set_charset("utf8mb4");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Search logic
$student_id = isset($_GET['student_id']) ? $_GET['student_id'] : '';
$payments = [];

if ($student_id) {
    $sql = "SELECT * FROM registrations WHERE student_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $student_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $payments = $result->fetch_all(MYSQLI_ASSOC);
    } else {
        $error = "No records found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Payment Search</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body { background-color: #f8f9fa; }
        .container { max-width: 800px; margin-top: 50px; }
        .table thead { background-color: #343a40; color: #fff; }
    </style>
</head>
<body>

<div class="container">
    <h2 class="text-center mb-4">Student Payment Search</h2>
    <form method="GET" class="mb-4">
        <div class="input-group">
            <input type="text" class="form-control" name="student_id" placeholder="Enter Student ID" value="<?php echo htmlspecialchars($student_id); ?>" required>
            <button type="submit" class="btn btn-primary">Search</button>
        </div>
    </form>

    <?php if (!empty($payments)): ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Student ID</th>
                    <th>Student Name</th>
                    <th>Payment Reference</th>
                    <th>Payment Amount</th>
                    <th>Due Amount</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($payments as $payment): ?>
                <tr>
                    <td><?php echo $payment['student_id']; ?></td>
                    <td><?php echo $payment['student_name']; ?></td>
                    <td><?php echo $payment['payment_reference']; ?></td>
                    <td><?php echo $payment['payment_amount']; ?></td>
                    <td><?php echo $payment['due_amount']; ?></td>
                    <td><?php echo $payment['start']; ?></td>
                    <td><?php echo $payment['end']; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php elseif(isset($error)): ?>
        <div class="alert alert-warning">No records found for Student ID: <?php echo htmlspecialchars($student_id); ?></div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
