<?php
// Enable error reporting (for debugging)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
$servername = "localhost";
$username = "uofsedu_Rmn";
$password = "Almnsi@27";
$dbname = "uofsedu_merowe_db";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

$verification_result = null;
$payment_data = null;
$reference = '';

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['reference'])) {
    $reference = trim($_POST['reference']);
    
    if (!empty($reference)) {
        // Prepare SQL statement to check payment status
        $sql = "SELECT name, phone_number, fee_type_id, reference, is_paid, amount, 
                       payment_currency, created_at, updated_at, notes 
                FROM other_fees 
                WHERE reference = ?";
        
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
            die("Database Error (prepare): " . $conn->error);
        }
        
        $stmt->bind_param("s", $reference);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $payment_data = $result->fetch_assoc();
            
            if ($payment_data['is_paid'] == 1) {
                $verification_result = "success";
                $status_message = "✅ تم تأكيد الدفع - تم معالجة الدفع بنجاح.";
            } else {
                $verification_result = "pending";
                $status_message = "⏳ الدفع معلق - لم يتم إكمال عملية الدفع بعد.";
            }
        } else {
            $verification_result = "not_found";
            $status_message = "❌ رقم المرجع غير موجود. يرجى التحقق والمحاولة مرة أخرى.";
        }
        
        $stmt->close();
    } else {
        $verification_result = "empty";
        $status_message = "⚠️ يرجى إدخال رقم المرجع.";
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التحقق من حالة الدفع - جامعة مروي</title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Font Cairo -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #1a5f7a;
            --secondary-color: #57cc99;
            --accent-color: #ff9a3c;
            --light-color: #f8f9fa;
            --dark-color: #2c3e50;
            --success-color: #28a745;
            --danger-color: #e74c3c;
            --warning-color: #f39c12;
            --shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --border-radius: 12px;
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Cairo', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            color: var(--dark-color);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            direction: rtl;
        }

        .container {
            background-color: white;
            padding: 40px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            max-width: 800px;
            width: 100%;
            position: relative;
            overflow: hidden;
            transition: var(--transition);
        }

        .container:hover {
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            position: relative;
            padding-bottom: 20px;
        }

        .header::after {
            content: '';
            position: absolute;
            bottom: 0;
            right: 50%;
            transform: translateX(50%);
            width: 100px;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            border-radius: 2px;
        }

        h1 {
            color: var(--primary-color);
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 10px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }

        .subtitle {
            color: #666;
            font-size: 1.1rem;
            margin-bottom: 5px;
        }

        .logo {
            text-align: center;
            margin-bottom: 25px;
        }

        .logo img {
            max-width: 180px;
            height: auto;
            filter: drop-shadow(0 5px 10px rgba(0, 0, 0, 0.1));
            transition: var(--transition);
        }

        .verification-form {
            margin-bottom: 30px;
            background-color: #f9f9f9;
            padding: 25px;
            border-radius: var(--border-radius);
            border-right: 5px solid var(--primary-color);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark-color);
            font-size: 1.1rem;
        }

        input[type="text"] {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e1e5eb;
            border-radius: var(--border-radius);
            font-size: 1.1rem;
            font-family: 'Cairo', sans-serif;
            transition: var(--transition);
            background-color: white;
        }

        input[type="text"]:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(26, 95, 122, 0.1);
        }

        button {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            padding: 16px 25px;
            border-radius: var(--border-radius);
            font-size: 1.2rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            font-family: 'Cairo', sans-serif;
            width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
        }

        button:hover {
            background: linear-gradient(to right, #154b61, #46b07c);
            transform: translateY(-3px);
            box-shadow: 0 7px 15px rgba(26, 95, 122, 0.3);
        }

        /* Result section styling */
        .result-section {
            margin-top: 30px;
            padding: 25px;
            border-radius: 8px;
            display: <?php echo ($verification_result !== null) ? 'block' : 'none'; ?>;
            animation: fadeIn 0.5s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Status message styling */
        .status-message {
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            text-align: center;
            font-weight: bold;
            font-size: 1.2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .success {
            background-color: #d5f4e6;
            color: #27ae60;
            border: 2px solid #2ecc71;
        }

        .pending {
            background-color: #fef9e7;
            color: #f39c12;
            border: 2px solid #f1c40f;
        }

        .error {
            background-color: #fdeaea;
            color: #e74c3c;
            border: 2px solid #e74c3c;
        }

        /* Payment details styling */
        .payment-details {
            background-color: #f8f9fa;
            padding: 25px;
            border-radius: var(--border-radius);
            border-right: 5px solid #3498db;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .payment-details h3 {
            color: var(--primary-color);
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #3498db;
            font-size: 1.5rem;
            text-align: center;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #eaeaea;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: var(--dark-color);
            font-size: 1.1rem;
        }

        .detail-value {
            color: #34495e;
            text-align: left;
            font-size: 1.1rem;
        }

        .paid-badge {
            background-color: #27ae60;
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 1rem;
            font-weight: bold;
            display: inline-block;
        }

        .pending-badge {
            background-color: #f39c12;
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 1rem;
            font-weight: bold;
            display: inline-block;
        }

        /* Action buttons styling */
        .action-buttons {
            text-align: center;
            margin-top: 30px;
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }

        .action-btn {
            background: linear-gradient(to right, var(--accent-color), #ff7a00);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: var(--border-radius);
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            font-family: 'Cairo', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            min-width: 200px;
            box-shadow: 0 5px 15px rgba(255, 154, 60, 0.3);
        }

        .action-btn:hover {
            background: linear-gradient(to right, #e68900, #e66a00);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(255, 154, 60, 0.4);
        }

        .action-btn.print {
            background: linear-gradient(to right, #95a5a6, #7f8c8d);
        }

        .action-btn.print:hover {
            background: linear-gradient(to right, #7f8c8d, #6c7b7d);
        }

        .action-btn.refresh {
            background: linear-gradient(to right, #3498db, #2980b9);
        }

        .action-btn.refresh:hover {
            background: linear-gradient(to right, #2980b9, #2573a7);
        }

        /* Decorative elements */
        .decorative-circle {
            position: absolute;
            width: 200px;
            height: 200px;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(87, 204, 153, 0.1) 0%, rgba(26, 95, 122, 0.05) 100%);
            top: -80px;
            left: -80px;
            z-index: 0;
        }

        .decorative-circle-2 {
            position: absolute;
            width: 150px;
            height: 150px;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(255, 154, 60, 0.1) 0%, rgba(87, 204, 153, 0.05) 100%);
            bottom: -60px;
            right: -60px;
            z-index: 0;
        }

        .form-content {
            position: relative;
            z-index: 1;
        }

        /* Print styles */
        @media print {
            body * {
                visibility: hidden;
            }
            .container, .container * {
                visibility: visible;
            }
            .container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                box-shadow: none;
            }
            .verification-form, .action-buttons, button {
                display: none !important;
            }
            .payment-details {
                border: 2px solid #000;
                page-break-inside: avoid;
            }
        }

        /* Responsive design */
        @media (max-width: 768px) {
            .container {
                padding: 30px 25px;
            }
            
            h1 {
                font-size: 1.8rem;
            }
            
            .detail-row {
                flex-direction: column;
            }
            
            .detail-label, .detail-value {
                width: 100%;
                text-align: right;
            }
            
            .detail-value {
                margin-top: 5px;
                text-align: left;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .action-btn {
                width: 100%;
                max-width: 300px;
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 25px 20px;
            }
            
            h1 {
                font-size: 1.6rem;
            }
            
            .status-message {
                font-size: 1rem;
            }
            
            .verification-form {
                padding: 20px 15px;
            }
            
            input[type="text"] {
                padding: 12px 15px;
                font-size: 1rem;
            }
            
            button {
                padding: 14px 20px;
                font-size: 1.1rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Decorative background elements -->
        <div class="decorative-circle"></div>
        <div class="decorative-circle-2"></div>
        
        <div class="form-content">
            <!-- Logo Section -->
            <div class="logo">
                <img src="images/merowe-logo.png" alt="شعار جامعة مروي" onerror="this.style.display='none'">
            </div>

            <!-- Header -->
            <div class="header">
                <h1>التحقق من حالة الدفع</h1>
                <p class="subtitle">جامعة مروي - بوابة السداد الإلكتروني</p>
                <p class="subtitle">أدخل رقم المرجع للتحقق من حالة الدفع</p>
            </div>

            <!-- Verification Form -->
            <div class="verification-form">
                <form action="" method="post">
                    <div class="form-group">
                        <label for="reference">رقم المرجع:</label>
                        <input type="text" id="reference" name="reference" 
                               value="<?php echo htmlspecialchars($reference); ?>" 
                               placeholder="أدخل رقم المرجع الخاص بالدفع" required>
                    </div>
                    <button type="submit">
                        <i class="fas fa-search-dollar"></i>
                        التحقق من حالة الدفع
                    </button>
                </form>
            </div>
            
            <?php if ($verification_result !== null): ?>
            <div class="result-section">
                <div class="status-message 
                    <?php 
                    if ($verification_result == 'success') echo 'success';
                    elseif ($verification_result == 'pending') echo 'pending';
                    else echo 'error';
                    ?>">
                    <?php echo $status_message; ?>
                </div>
                
                <?php if ($payment_data): ?>
                <div class="payment-details">
                    <h3>تفاصيل الدفع</h3>
                    
                    <div class="detail-row">
                        <div class="detail-label">رقم المرجع:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['reference']); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">الاسم:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['name']); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">رقم الهاتف:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['phone_number']); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">المبلغ:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['amount']); ?> <?php echo htmlspecialchars($payment_data['payment_currency']); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">رقم نوع الرسوم:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['fee_type_id']); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">حالة الدفع:</div>
                        <div class="detail-value">
                            <?php if ($payment_data['is_paid'] == 1): ?>
                                <span class="paid-badge">✅ تم الدفع</span>
                            <?php else: ?>
                                <span class="pending-badge">⏳ قيد الانتظار</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">تاريخ الإنشاء:</div>
                        <div class="detail-value"><?php echo date('Y-m-d H:i:s', strtotime($payment_data['created_at'])); ?></div>
                    </div>
                    
                    <div class="detail-row">
                        <div class="detail-label">آخر تحديث:</div>
                        <div class="detail-value"><?php echo date('Y-m-d H:i:s', strtotime($payment_data['updated_at'])); ?></div>
                    </div>
                    
                    <?php if (!empty($payment_data['notes'])): ?>
                    <div class="detail-row">
                        <div class="detail-label">ملاحظات:</div>
                        <div class="detail-value"><?php echo htmlspecialchars($payment_data['notes']); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <div class="action-buttons">
                    <?php if ($verification_result == 'success'): ?>
                    <button class="action-btn print" onclick="window.print()">
                        <i class="fas fa-print"></i>
                        طباعة الإيصال
                    </button>
                    <button class="action-btn refresh" onclick="location.reload()">
                        <i class="fas fa-redo"></i>
                        التحقق من دفعة أخرى
                    </button>
                    <?php elseif ($verification_result == 'pending'): ?>
                    <button class="action-btn refresh" onclick="location.reload()">
                        <i class="fas fa-redo"></i>
                        التحقق من دفعة أخرى
                    </button>
                    <?php else: ?>
                    <button class="action-btn refresh" onclick="location.reload()">
                        <i class="fas fa-redo"></i>
                        المحاولة مرة أخرى
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Footer -->
            <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; color: #777; font-size: 0.9rem;">
                <p>© <span id="current-year">2024</span> جامعة مروي التكنلوجية - جميع الحقوق محفوظة</p>
                <p>للاستفسارات: <i class="fas fa-envelope"></i> payment@merowe.edu.sd | <i class="fas fa-phone"></i> 249-123456789</p>
            </div>
        </div>
    </div>
    
    <script>
        // Set current year
        document.getElementById('current-year').textContent = new Date().getFullYear();
        
        // Focus on the reference input field
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('reference').focus();
        });
        
        // Show result section when there's a verification result
        <?php if ($verification_result !== null): ?>
            document.querySelector('.result-section').style.display = 'block';
        <?php endif; ?>
        
        // Print receipt function
        function printReceipt() {
            window.print();
        }
    </script>
</body>
</html>