<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set Arabic language headers
header('Content-Type: text/html; charset=utf-8');

// API endpoint (replace with your actual API URL)
$apiUrl = 'http://62.164.219.146:8000/api/v2/image/validate';
$apiKey = '9tZwimURlQMdn8VaI2IAGSFQ4fgbJVd9'; // Replace with your actual API key

// hCaptcha Configuration
$hcaptchaSecret = 'ES_044e9c8acdab4dbcaadc0c43350de0db'; // Get this from hCaptcha dashboard
$hcaptchaSiteKey = '5fe6e70c-a530-4240-99a2-0c8ca8e0be96'; // Your provided site key

$apiResponse = null;
$error = null;
$success = null;
$imagePreview = null;
$studentNumber = '';

// Translation arrays
$validationLabels = [
    'faceDetected' => 'اكتشاف الوجه',
    'faceCentered' => 'الوجه في المنتصف',
    'appropriateHeadSize' => 'حجم الرأس مناسب',
    'whiteBackground' => 'خلفية بيضاء',
    'imageQuality' => 'جودة الصورة',
    'noGlasses' => 'بدون نظارات',
    'neutralExpression' => 'تعبير محايد',
    'eyesOpen' => 'العينان مفتوحتان',
    'goodLighting' => 'إضاءة جيدة',
    'noHeadwear' => 'بدون غطاء رأس'
];

$validationDescriptions = [
    'faceDetected' => 'تم اكتشاف وجه واضح في الصورة',
    'faceCentered' => 'الوجه موجود في منتصف الصورة بشكل مناسب',
    'appropriateHeadSize' => 'حجم الرأس يشغل النسبة الصحيحة من الصورة',
    'whiteBackground' => 'الخلفية بيضاء نقية ومناسبة',
    'imageQuality' => 'الصورة واضحة وحادة بدون تشويش',
    'noGlasses' => 'الوجه يظهر بدون نظارات',
    'neutralExpression' => 'التعبير الوجهي محايد وطبيعي',
    'eyesOpen' => 'العينان مفتوحتان وواضحتان',
    'goodLighting' => 'الإضاءة موزعة بشكل متساوي على الوجه',
    'noHeadwear' => 'الوجه يظهر بدون أي غطاء للرأس'
];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($apiKey)) {
    // Get student number
    $studentNumber = trim($_POST['student_number'] ?? '');
    
    // Validate student number
    if (empty($studentNumber)) {
        $error = "الرجاء إدخال رقم الطالب.";
    } elseif (!preg_match('/^[A-Za-z0-9\-_]+$/', $studentNumber)) {
        $error = "رقم الطالب يمكن أن يحتوي فقط على أحرف، أرقام، شرطات، وشرطات سفلية.";
    } else {
        // Validate hCaptcha
        $hcaptchaResponse = $_POST['h-captcha-response'] ?? '';
        if (empty($hcaptchaResponse)) {
            $error = "الرجاء إكمال التحقق من أنك لست روبوتًا.";
        } else {
            // Verify hCaptcha response
            $isCaptchaValid = false;
            
            $verifyData = [
                'secret' => $hcaptchaSecret,
                'response' => $hcaptchaResponse,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            ];
            
            $ch = curl_init('https://hcaptcha.com/siteverify');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($verifyData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/x-www-form-urlencoded'
            ]);
            
            $verifyResponse = curl_exec($ch);
            $verifyResult = json_decode($verifyResponse, true);
            $isCaptchaValid = $verifyResult['success'] ?? false;
            
            
            if (!$isCaptchaValid) {
                $error = "فشل التحقق من أنك لست روبوتًا. الرجاء المحاولة مرة أخرى.";
                if (isset($verifyResult['error-codes'])) {
                    error_log("hCaptcha Error: " . implode(', ', $verifyResult['error-codes']));
                }
            } else {
                // Check if file was uploaded without errors
                if (isset($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
                    // Validate file type
                    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
                    $fileType = mime_content_type($_FILES['photo']['tmp_name']);
                    
                    if (!in_array($fileType, $allowedTypes)) {
                        $error = "نوع الملف غير صالح. يُسمح فقط بصور JPEG و PNG و GIF و WebP.";
                    } else {
                        // Validate file size (max 5MB)
                        $maxFileSize = 5 * 1024 * 1024; // 5MB
                        if ($_FILES['photo']['size'] > $maxFileSize) {
                            $error = "الملف كبير جدًا. الحد الأقصى للحجم هو 5 ميجابايت.";
                        } else {
                            // Read and convert file to base64
                            $imageData = file_get_contents($_FILES['photo']['tmp_name']);
                            $base64Image = base64_encode($imageData);
                            
                            // Prepare for image preview
                            $imagePreview = 'data:' . $fileType . ';base64,' . base64_encode($imageData);
                            
                            // Prepare the JSON data for API
                            $jsonData = json_encode([
                                'image_base64' => $base64Image
                            ]);
                            
                            // Initialize cURL session
                            $ch = curl_init($apiUrl);
                            
                            // Set cURL options with X-API-Key header
                            $headers = [
                                'Content-Type: application/json',
                                'Content-Length: ' . strlen($jsonData),
                                'X-API-Key: ' . $apiKey
                            ];
                            
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                            
                            // Execute the request
                            $response = curl_exec($ch);
                            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                            
                            // Check for cURL errors
                            if (curl_errno($ch)) {
                                $error = 'خطأ في الاتصال بالخادم: ' . curl_error($ch);
                            } else {
                                // Check HTTP status code
                                if ($httpCode === 401) {
                                    $error = 'فشل المصادقة: مفتاح API غير صالح';
                                } elseif ($httpCode === 403) {
                                    $error = 'محظور الوصول: مفتاح API لا يملك الصلاحية';
                                } elseif ($httpCode >= 200 && $httpCode < 300) {
                                    // Parse JSON response
                                    $apiResponse = json_decode($response, true);
                                    
                                    // Check if JSON parsing was successful
                                    if (json_last_error() !== JSON_ERROR_NONE) {
                                        $error = 'رد غير صالح من الخادم: ' . json_last_error_msg();
                                        $apiResponse = null;
                                    } else {
                                        // Check if validation response exists
                                        $isValid = true;
                                        $validationResults = [];
                                        
                                        // Extract validation results from response
                                        // Support both response formats
                                        if (isset($apiResponse['validation'])) {
                                            $validationResults = $apiResponse['validation'];
                                        } elseif (isset($apiResponse['faceDetected']) || isset($apiResponse['face_detected'])) {
                                            // Extract individual validation fields
                                            $validationFields = [
                                                'faceDetected', 'face_detected',
                                                'faceCentered', 'face_centered',
                                                'appropriateHeadSize', 'appropriate_head_size',
                                                'whiteBackground', 'white_background'
                                            ];
                                            
                                            foreach ($validationFields as $field) {
                                                if (isset($apiResponse[$field])) {
                                                    // Normalize field names (convert snake_case to camelCase)
                                                    $normalizedField = str_replace('_', '', lcfirst(ucwords($field, '_')));
                                                    $validationResults[$normalizedField] = $apiResponse[$field];
                                                }
                                            }
                                        }
                                        
                                        // Check if all validations are true
                                        foreach ($validationResults as $value) {
                                            if ($value !== true) {
                                                $isValid = false;
                                                break;
                                            }
                                        }
                                        
                                        // If validation passed, save the image
                                        if ($isValid && !empty($validationResults)) {
                                            // Create uploads directory if it doesn't exist
                                            $uploadDir = 'uploads/';
                                            if (!is_dir($uploadDir)) {
                                                mkdir($uploadDir, 0755, true);
                                            }
                                            
                                            // Determine file extension based on MIME type
                                            $extensions = [
                                                'image/jpeg' => 'jpg',
                                                'image/png' => 'png',
                                                'image/gif' => 'gif',
                                                'image/webp' => 'webp'
                                            ];
                                            
                                            $extension = $extensions[$fileType] ?? 'jpg';
                                            $filename = $studentNumber . '.' . $extension;
                                            $filepath = $uploadDir . $filename;
                                            
                                            // Check if file already exists and create unique name if needed
                                            $counter = 1;
                                            while (file_exists($filepath)) {
                                                $filename = $studentNumber . '_' . $counter . '.' . $extension;
                                                $filepath = $uploadDir . $filename;
                                                $counter++;
                                            }
                                            
                                            // Save the original uploaded file
                                            if (move_uploaded_file($_FILES['photo']['tmp_name'], $filepath)) {
                                                $success = "تم حفظ الصورة بنجاح باسم: " . htmlspecialchars($filename);
                                            } else {
                                                $error = "فشل حفظ الصورة على القرص.";
                                            }
                                        } elseif (empty($validationResults)) {
                                            $error = "لم يتم استلام نتائج التحقق من الخادم.";
                                        }
                                    }
                                } else {
                                    $error = "فشل طلب API برمز HTTP: $httpCode";
                                }
                            }
                            
                            // Close cURL session
                            curl_close($ch);
                        }
                    }
                } else {
                    // Handle upload errors in Arabic
                    $uploadError = $_FILES['photo']['error'] ?? null;
                    switch ($uploadError) {
                        case UPLOAD_ERR_INI_SIZE:
                        case UPLOAD_ERR_FORM_SIZE:
                            $error = "الملف كبير جدًا.";
                            break;
                        case UPLOAD_ERR_PARTIAL:
                            $error = "تم رفع الملف جزئيًا فقط.";
                            break;
                        case UPLOAD_ERR_NO_FILE:
                            $error = "لم يتم رفع أي ملف.";
                            break;
                        case UPLOAD_ERR_NO_TMP_DIR:
                            $error = "مجلد مؤقت مفقود.";
                            break;
                        case UPLOAD_ERR_CANT_WRITE:
                            $error = "فشل كتابة الملف على القرص.";
                            break;
                        case UPLOAD_ERR_EXTENSION:
                            $error = "توقف رفع الملف بواسطة الامتداد.";
                            break;
                        default:
                            $error = "خطأ غير معروف في الرفع.";
                            break;
                    }
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام رفع صور الطلاب</title>
    <!-- Arabic font -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- hCaptcha Script -->
    <script src="https://js.hcaptcha.com/1/api.js" async defer></script>
    <style>
        :root {
            /* Logo Color Palette */
            --bright-gold: #f9dd10ff;
            --dusty-taupe: #b19685ff;
            --old-gold: #d0b931ff;
            --dark-emerald: #1a642bff;
            --coffee-bean: #1f150cff;
            
            /* Derived colors */
            --bright-gold-light: rgba(249, 221, 16, 0.1);
            --dark-emerald-light: rgba(26, 100, 43, 0.1);
            --coffee-bean-light: rgba(31, 21, 12, 0.05);
            --dusty-taupe-light: rgba(177, 150, 133, 0.1);
            --old-gold-light: rgba(208, 185, 49, 0.1);
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Cairo', sans-serif;
            line-height: 1.8;
            color: var(--coffee-bean);
            background: linear-gradient(135deg, var(--dark-emerald-light) 0%, var(--dusty-taupe-light) 100%);
            min-height: 100vh;
            padding: 20px;
            text-align: right;
            background-attachment: fixed;
        }
        
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(31, 21, 12, 0.15);
            overflow: hidden;
            border: 1px solid var(--dusty-taupe);
            position: relative;
        }
        
        .container::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--bright-gold), var(--old-gold), var(--dark-emerald));
        }
        
        .header {
            background: linear-gradient(135deg, var(--dark-emerald) 0%, var(--coffee-bean) 100%);
            color: white;
            padding: 50px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 30% 20%, rgba(249, 221, 16, 0.1) 0%, transparent 70%);
        }
        
        .header h1 {
            font-size: 2.8rem;
            margin-bottom: 15px;
            position: relative;
            z-index: 1;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }
        
        .header h1 i {
            color: var(--bright-gold);
            margin-left: 15px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 1.2rem;
            position: relative;
            z-index: 1;
        }
        
        .content {
            padding: 40px;
        }
        
        .upload-form {
            margin-bottom: 40px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: var(--dark-emerald);
            font-size: 1.1rem;
        }
        
        .form-group input[type="text"] {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid var(--dusty-taupe);
            border-radius: 10px;
            font-size: 1rem;
            font-family: 'Cairo', sans-serif;
            transition: all 0.3s ease;
            background: var(--coffee-bean-light);
        }
        
        .form-group input[type="text"]:focus {
            outline: none;
            border-color: var(--dark-emerald);
            box-shadow: 0 0 0 3px var(--dark-emerald-light);
            background: white;
        }
        
        /* hCaptcha Container */
        .hcaptcha-container {
            background: linear-gradient(135deg, var(--old-gold-light) 0%, var(--bright-gold-light) 100%);
            padding: 30px;
            border-radius: 15px;
            border: 2px solid var(--old-gold);
            margin: 30px 0;
            text-align: center;
        }
        
        .hcaptcha-instruction {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 25px;
            color: var(--coffee-bean);
            font-size: 1.2rem;
            font-weight: 600;
        }
        
        .h-captcha {
            display: flex;
            justify-content: center;
            margin: 20px 0;
        }
        
        .hcaptcha-info {
            color: var(--dusty-taupe);
            font-size: 0.9rem;
            margin-top: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .file-input-wrapper {
            position: relative;
            margin: 20px 0;
        }
        
        .file-input {
            width: 100%;
            padding: 25px;
            border: 2px dashed var(--dark-emerald);
            border-radius: 12px;
            background: var(--dark-emerald-light);
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: 'Cairo', sans-serif;
            font-size: 1.1rem;
        }
        
        .file-input:hover {
            border-color: var(--bright-gold);
            background: var(--bright-gold-light);
            transform: translateY(-2px);
        }
        
        .submit-btn {
            background: linear-gradient(135deg, var(--dark-emerald) 0%, var(--coffee-bean) 100%);
            color: white;
            border: none;
            padding: 18px 50px;
            font-size: 1.2rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: block;
            margin: 40px auto 0;
            font-family: 'Cairo', sans-serif;
            font-weight: 600;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 20px rgba(26, 100, 43, 0.2);
        }
        
        .submit-btn:hover:not(:disabled) {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(26, 100, 43, 0.3);
        }
        
        .submit-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .error {
            background: linear-gradient(135deg, rgba(244, 67, 54, 0.1) 0%, rgba(244, 67, 54, 0.2) 100%);
            border-right: 4px solid #f44336;
            padding: 25px;
            margin: 25px 0;
            border-radius: 12px;
            text-align: right;
            font-size: 1.1rem;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }
        
        .success {
            background: linear-gradient(135deg, rgba(76, 175, 80, 0.1) 0%, rgba(76, 175, 80, 0.2) 100%);
            border-right: 4px solid #4caf50;
            padding: 25px;
            margin: 25px 0;
            border-radius: 12px;
            text-align: right;
            font-size: 1.2rem;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }
        
        .preview-section {
            margin: 30px 0;
            padding: 30px;
            background: linear-gradient(135deg, var(--coffee-bean-light) 0%, white 100%);
            border-radius: 15px;
            border: 1px solid var(--dusty-taupe);
        }
        
        .preview-section h3 {
            color: var(--dark-emerald);
            margin-bottom: 25px;
            font-size: 1.4rem;
            display: flex;
            align-items: center;
            gap: 12px;
            justify-content: flex-start;
        }
        
        .image-preview {
            max-width: 300px;
            max-height: 300px;
            margin: 20px auto;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(31, 21, 12, 0.15);
            display: block;
            border: 3px solid var(--dusty-taupe);
        }
        
        /* Validation Results Section */
        .validation-results {
            margin-top: 40px;
            padding: 30px;
            background: linear-gradient(135deg, var(--coffee-bean-light) 0%, white 100%);
            border-radius: 20px;
            border: 1px solid var(--dusty-taupe);
        }
        
        .validation-results h3 {
            color: var(--coffee-bean);
            margin-bottom: 30px;
            font-size: 1.6rem;
            border-bottom: 3px solid var(--bright-gold);
            padding-bottom: 15px;
            text-align: center;
        }
        
        .overall-status {
            text-align: center;
            margin-bottom: 40px;
            padding: 30px;
            border-radius: 15px;
            background: linear-gradient(135deg, var(--coffee-bean) 0%, var(--dark-emerald) 100%);
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .overall-status::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 20% 50%, rgba(249, 221, 16, 0.2) 0%, transparent 70%);
        }
        
        .status-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .status-title {
            font-size: 2rem;
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .status-message {
            font-size: 1.2rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Validation Grid */
        .validation-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
            margin: 40px 0;
        }
        
        .validation-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 8px 25px rgba(31, 21, 12, 0.1);
            border: 2px solid var(--dusty-taupe);
            transition: all 0.3s ease;
            text-align: right;
            position: relative;
            overflow: hidden;
        }
        
        .validation-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(31, 21, 12, 0.15);
        }
        
        .validation-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 5px;
            height: 100%;
            transition: all 0.3s ease;
        }
        
        .validation-card.valid {
            border-color: var(--dark-emerald);
            background: var(--dark-emerald-light);
        }
        
        .validation-card.valid::before {
            background: var(--dark-emerald);
        }
        
        .validation-card.invalid {
            border-color: #f44336;
            background: rgba(244, 67, 54, 0.1);
        }
        
        .validation-card.invalid::before {
            background: #f44336;
        }
        
        .validation-card-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .validation-icon {
            font-size: 2.5rem;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: white;
            flex-shrink: 0;
        }
        
        .validation-card.valid .validation-icon {
            color: var(--dark-emerald);
            border: 2px solid var(--dark-emerald);
        }
        
        .validation-card.invalid .validation-icon {
            color: #f44336;
            border: 2px solid #f44336;
        }
        
        .validation-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--coffee-bean);
            margin-bottom: 5px;
        }
        
        .validation-status {
            font-size: 1rem;
            font-weight: 600;
            padding: 5px 15px;
            border-radius: 20px;
            display: inline-block;
        }
        
        .validation-card.valid .validation-status {
            background: var(--dark-emerald);
            color: white;
        }
        
        .validation-card.invalid .validation-status {
            background: #f44336;
            color: white;
        }
        
        .validation-description {
            color: var(--coffee-bean);
            font-size: 1rem;
            line-height: 1.6;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid rgba(177, 150, 133, 0.3);
        }
        
        /* Stats Summary */
        .stats-summary {
            display: flex;
            justify-content: center;
            gap: 30px;
            margin: 40px 0;
            flex-wrap: wrap;
        }
        
        .stat-item {
            text-align: center;
            background: linear-gradient(135deg, var(--bright-gold-light) 0%, var(--old-gold-light) 100%);
            padding: 25px;
            border-radius: 15px;
            min-width: 180px;
            border: 2px solid var(--old-gold);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            color: var(--dark-emerald);
            margin-bottom: 10px;
            line-height: 1;
        }
        
        .stat-label {
            font-size: 1.1rem;
            color: var(--coffee-bean);
            font-weight: 600;
        }
        
        /* Recommendations */
        .recommendations {
            background: linear-gradient(135deg, var(--bright-gold-light) 0%, var(--old-gold-light) 100%);
            border-right: 4px solid var(--old-gold);
            padding: 30px;
            margin: 40px 0;
            border-radius: 15px;
            border: 1px solid var(--old-gold);
        }
        
        .recommendations h4 {
            color: var(--coffee-bean);
            font-size: 1.4rem;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .recommendations ul {
            margin-right: 25px;
        }
        
        .recommendations li {
            margin-bottom: 15px;
            padding-right: 15px;
            color: var(--coffee-bean);
            line-height: 1.6;
        }
        
        /* Info Box */
        .info-box {
            background: linear-gradient(135deg, var(--dark-emerald-light) 0%, var(--coffee-bean-light) 100%);
            border-right: 4px solid var(--dark-emerald);
            padding: 30px;
            margin: 30px 0;
            border-radius: 15px;
            border: 1px solid var(--dark-emerald);
        }
        
        .info-box strong {
            color: var(--coffee-bean);
            font-size: 1.3rem;
            display: block;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .info-box ol {
            margin-right: 25px;
            margin-top: 15px;
        }
        
        .info-box li {
            margin-bottom: 15px;
            padding-right: 15px;
            color: var(--coffee-bean);
        }
        
        /* Loading animation */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid var(--dusty-taupe);
            border-top: 3px solid var(--bright-gold);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }
        
        /* Security badge */
        .security-badge {
            position: absolute;
            top: 20px;
            left: 20px;
            background: linear-gradient(135deg, var(--dark-emerald) 0%, var(--coffee-bean) 100%);
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 10px;
            z-index: 10;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
        
        @media (max-width: 768px) {
            .container {
                margin: 10px;
                border-radius: 15px;
            }
            
            .content {
                padding: 25px;
            }
            
            .header h1 {
                font-size: 2rem;
            }
            
            .validation-grid {
                grid-template-columns: 1fr;
            }
            
            .stats-summary {
                flex-direction: column;
                gap: 20px;
            }
            
            .security-badge {
                position: relative;
                top: 0;
                left: 0;
                margin-bottom: 20px;
                justify-content: center;
            }
            
            .overall-status {
                padding: 20px;
            }
            
            .status-icon {
                font-size: 3rem;
            }
            
            .status-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Security Badge -->
        <div class="security-badge">
            <i class="fas fa-shield-alt"></i>
            محمي بـ hCaptcha
        </div>
        
        <div class="header">
            <h1><i class="fas fa-graduation-cap"></i> نظام رفع صور الطلاب</h1>
            <p>رفع صور الطلاب مع التحقق الآلي والتسمية التلقائية</p>
        </div>
        
        <div class="content">
            <!-- System Status -->
            <?php if (empty($apiKey)): ?>
                <div class="error">
                    <strong>⚠️ خطأ في إعداد النظام</strong>
                    <p>مفتاح API غير مضبوط. يرجى الاتصال بالمسؤول.</p>
                </div>
            <?php endif; ?>
            
            <!-- Upload Form -->
            <form method="POST" enctype="multipart/form-data" class="upload-form" id="uploadForm">
                <div class="form-group">
                    <label for="student_number"><i class="fas fa-id-card"></i> رقم الطالب *</label>
                    <input type="text" 
                           id="student_number" 
                           name="student_number" 
                           value="<?php echo htmlspecialchars($studentNumber); ?>"
                           placeholder="أدخل رقم الطالب (مثال: STU2024001)"
                           required
                           pattern="[A-Za-z0-9\-_]+"
                           title="يُسمح فقط بالأحرف، الأرقام، الشرطات، والشرطات السفلية"
                           <?php echo empty($apiKey) ? 'disabled' : ''; ?>>
                </div>
                
                <div class="form-group">
                    <label for="photo"><i class="fas fa-camera"></i> صورة الطالب *</label>
                    <div class="file-input-wrapper">
                        <input type="file" 
                               name="photo" 
                               id="photo" 
                               accept="image/*" 
                               required 
                               class="file-input"
                               onchange="previewImage(this)"
                               <?php echo empty($apiKey) ? 'disabled' : ''; ?>>
                    </div>
                </div>
                
                <!-- hCaptcha Section -->
                <div class="hcaptcha-container">
                    <div class="hcaptcha-instruction">
                        <i class="fas fa-robot"></i>
                        <span>الرجاء التحقق من أنك لست روبوتًا</span>
                    </div>
                    
                    <div class="h-captcha" 
                         data-sitekey="5fe6e70c-a530-4240-99a2-0c8ca8e0be96"
                         data-theme="light"
                         data-size="normal"
                         data-callback="onCaptchaSuccess"
                         data-expired-callback="onCaptchaExpired">
                    </div>
                    
                    <div class="hcaptcha-info">
                        <i class="fas fa-info-circle"></i>
                        هذا التحقق يضمن أمان النظام ويمنع الاستخدام الآلي
                    </div>
                </div>
                
                <button type="submit" 
                        class="submit-btn" 
                        id="submitBtn"
                        disabled>
                    <span id="submitText">
                        <?php echo empty($apiKey) ? '⚠️ النظام غير متاح' : '<i class="fas fa-upload"></i> رفع وتحقق من الصورة'; ?>
                    </span>
                </button>
            </form>
            
            <!-- Live Image Preview -->
            <div class="preview-section" id="livePreviewSection" style="display: none;">
                <h3><i class="fas fa-eye"></i> معاينة الصورة</h3>
                <div id="imagePreviewContainer"></div>
                <div class="stats-box" id="imageStats"></div>
            </div>
            
            <!-- Success Message -->
            <?php if ($success): ?>
                <div class="success">
                    <div style="display: flex; align-items: center; gap: 20px;">
                        <span style="font-size: 2.5rem; color: var(--dark-emerald);">✅</span>
                        <div>
                            <h4 style="margin: 0 0 10px 0; color: var(--dark-emerald);">تم بنجاح!</h4>
                            <p style="margin: 0; color: var(--coffee-bean);"><?php echo htmlspecialchars($success); ?></p>
                            <?php if (isset($filepath) && file_exists($filepath)): ?>
                                <p style="margin: 10px 0 0 0; font-size: 0.9rem; color: var(--dusty-taupe);">
                                    <strong>المسار:</strong> <?php echo htmlspecialchars($filepath); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Error Display -->
            <?php if ($error): ?>
                <div class="error">
                    <div style="display: flex; align-items: center; gap: 20px;">
                        <span style="font-size: 2.5rem; color: #f44336;">❌</span>
                        <div>
                            <h4 style="margin: 0 0 10px 0; color: #f44336;">خطأ</h4>
                            <p style="margin: 0; color: var(--coffee-bean);"><?php echo htmlspecialchars($error); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Uploaded Image Preview -->
            <?php if ($imagePreview): ?>
                <div class="preview-section">
                    <h3><i class="fas fa-image"></i> الصورة المرفوعة</h3>
                    <img src="<?php echo htmlspecialchars($imagePreview); ?>" alt="الصورة المرفوعة" class="image-preview">
                    <div style="text-align: center; margin-top: 20px;">
                        <span style="background: linear-gradient(135deg, var(--bright-gold) 0%, var(--old-gold) 100%); color: var(--coffee-bean); padding: 10px 20px; border-radius: 25px; font-weight: 600; border: 2px solid var(--old-gold);">
                            <i class="fas fa-user-graduate"></i> رقم الطالب: <?php echo htmlspecialchars($studentNumber); ?>
                        </span>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Validation Results -->
            <?php 
            // Extract validation results from API response
            $validationResults = [];
            if ($apiResponse) {
                if (isset($apiResponse['validation'])) {
                    $validationResults = $apiResponse['validation'];
                } else {
                    // Extract individual validation fields
                    $validationFields = [
                        'faceDetected', 'face_detected',
                        'faceCentered', 'face_centered',
                        'appropriateHeadSize', 'appropriate_head_size',
                        'whiteBackground', 'white_background'
                    ];
                    
                    foreach ($validationFields as $field) {
                        if (isset($apiResponse[$field])) {
                            $normalizedField = str_replace('_', '', lcfirst(ucwords($field, '_')));
                            $validationResults[$normalizedField] = $apiResponse[$field];
                        }
                    }
                }
            }
            
            if (!empty($validationResults)): 
                $allValid = true;
                $validCount = 0;
                $totalCount = count($validationResults);
                
                foreach ($validationResults as $value) {
                    if ($value === true) {
                        $validCount++;
                    } else {
                        $allValid = false;
                    }
                }
                
                $successPercentage = $totalCount > 0 ? round(($validCount / $totalCount) * 100) : 0;
            ?>
                <div class="validation-results">
                    <h3><i class="fas fa-clipboard-check"></i> نتائج التحقق</h3>
                    
                    <!-- Overall Status -->
                    <div class="overall-status">
                        <div class="status-icon">
                            <?php if ($allValid): ?>
                                <i class="fas fa-check-circle"></i>
                            <?php elseif ($successPercentage >= 50): ?>
                                <i class="fas fa-exclamation-circle"></i>
                            <?php else: ?>
                                <i class="fas fa-times-circle"></i>
                            <?php endif; ?>
                        </div>
                        
                        <div class="status-title">
                            <?php if ($allValid): ?>
                                ✅ تم التحقق بنجاح
                            <?php elseif ($successPercentage >= 50): ?>
                                ⚠️ يحتاج تحسين
                            <?php else: ?>
                                ❌ فشل التحقق
                            <?php endif; ?>
                        </div>
                        
                        <div class="status-message">
                            <?php if ($allValid): ?>
                                تهانينا! الصورة تستوفي جميع معايير الصور الشخصية بنجاح.
                            <?php elseif ($successPercentage >= 50): ?>
                                الصورة تحتاج إلى بعض التحسينات لتلبية جميع المعايير.
                            <?php else: ?>
                                الصورة لا تلبي معظم معايير الصور الشخصية.
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Stats Summary -->
                    <div class="stats-summary">
                        <div class="stat-item">
                            <div class="stat-number"><?php echo $validCount; ?>/<?php echo $totalCount; ?></div>
                            <div class="stat-label">معايير ناجحة</div>
                        </div>
                        
                        <div class="stat-item">
                            <div class="stat-number"><?php echo $successPercentage; ?>%</div>
                            <div class="stat-label">نسبة النجاح</div>
                        </div>
                        
                        <div class="stat-item">
                            <div class="stat-number">
                                <?php if ($allValid): ?>
                                    ✅
                                <?php else: ?>
                                    ⚠️
                                <?php endif; ?>
                            </div>
                            <div class="stat-label">الحالة النهائية</div>
                        </div>
                    </div>
                    
                    <!-- Validation Details -->
                    <div class="validation-grid">
                        <?php foreach ($validationResults as $key => $value): 
                            $isValid = $value === true;
                            $arabicLabel = $validationLabels[$key] ?? $key;
                            $arabicDescription = $validationDescriptions[$key] ?? 'معيار التحقق';
                        ?>
                            <div class="validation-card <?php echo $isValid ? 'valid' : 'invalid'; ?>">
                                <div class="validation-card-header">
                                    <div class="validation-icon">
                                        <?php if ($isValid): ?>
                                            <i class="fas fa-check"></i>
                                        <?php else: ?>
                                            <i class="fas fa-times"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="validation-title"><?php echo htmlspecialchars($arabicLabel); ?></div>
                                        <span class="validation-status">
                                            <?php echo $isValid ? 'ناجح' : 'فاشل'; ?>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="validation-description">
                                    <?php echo htmlspecialchars($arabicDescription); ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <!-- Recommendations -->
                    <?php if (!$allValid): ?>
                        <div class="recommendations">
                            <h4><i class="fas fa-lightbulb"></i> نصائح للتحسين</h4>
                            <ul>
                                <?php if (isset($validationResults['faceDetected']) && !$validationResults['faceDetected']): ?>
                                    <li>تأكد من ظهور وجهك بوضوح في الصورة</li>
                                <?php endif; ?>
                                
                                <?php if (isset($validationResults['faceCentered']) && !$validationResults['faceCentered']): ?>
                                    <li>ضع وجهك في منتصف الصورة مع ترك مسافة مناسبة من جميع الجوانب</li>
                                <?php endif; ?>
                                
                                <?php if (isset($validationResults['appropriateHeadSize']) && !$validationResults['appropriateHeadSize']): ?>
                                    <li>تأكد أن حجم رأسك يشغل حوالي 60-70% من ارتفاع الصورة</li>
                                <?php endif; ?>
                                
                                <?php if (isset($validationResults['whiteBackground']) && !$validationResults['whiteBackground']): ?>
                                    <li>استخدم خلفية بيضاء نقية بدون أي أنماط أو ألوان</li>
                                <?php endif; ?>
                                
                                <li>تأكد من أن الإضاءة جيدة وموزعة بشكل متساوي على الوجه</li>
                                <li>حافظ على تعبير وجه محايد مع فتح العينين</li>
                                <li>تجنب ارتداء النظارات أو أي غطاء للرأس</li>
                                <li>استخدم كاميرا عالية الجودة لضمان وضوح الصورة</li>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Final Result -->
                    <div class="info-box" style="text-align: center;">
                        <?php if ($allValid): ?>
                            <div style="color: var(--dark-emerald); font-size: 1.5rem; font-weight: 700; margin-bottom: 15px;">
                                <i class="fas fa-trophy"></i> الصورة مقبولة!
                            </div>
                            <p style="color: var(--coffee-bean); margin-bottom: 15px;">
                                يمكنك الآن استخدام هذه الصورة للأغراض الرسمية
                            </p>
                        <?php else: ?>
                            <div style="color: #f44336; font-size: 1.5rem; font-weight: 700; margin-bottom: 15px;">
                                <i class="fas fa-exclamation-triangle"></i> الصورة تحتاج تحسين
                            </div>
                            <p style="color: var(--coffee-bean); margin-bottom: 15px;">
                                الرجاء اتباع النصائح أعلاه وإعادة رفع الصورة
                            </p>
                        <?php endif; ?>
                        
                        <?php if (isset($success)): ?>
                            <div style="margin-top: 20px; padding: 15px; background: var(--dark-emerald-light); border-radius: 10px; border: 2px solid var(--dark-emerald);">
                                <i class="fas fa-save"></i> تم حفظ الصورة بنجاح
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            
         
        </div>
    </div>

    <script>
        // Image preview functionality
        function previewImage(input) {
            const previewSection = document.getElementById('livePreviewSection');
            const previewContainer = document.getElementById('imagePreviewContainer');
            const statsContainer = document.getElementById('imageStats');
            
            if (input.files && input.files[0]) {
                const file = input.files[0];
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    // Show preview section
                    previewSection.style.display = 'block';
                    
                    // Create image preview
                    previewContainer.innerHTML = `
                        <img src="${e.target.result}" class="image-preview" alt="معاينة الصورة">
                    `;
                    
                    // Create image stats in Arabic
                    const fileSize = (file.size / 1024 / 1024).toFixed(2);
                    const fileType = file.type.split('/')[1]?.toUpperCase() || 'غير معروف';
                    
                    const img = new Image();
                    img.onload = function() {
                        const dimensionsText = `${this.width} × ${this.height} بكسل`;
                        statsContainer.innerHTML = `
                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 20px; margin: 25px 0;">
                                <div style="background: linear-gradient(135deg, var(--dark-emerald-light) 0%, transparent 100%); padding: 20px; border-radius: 10px; border: 1px solid var(--dark-emerald); text-align: center;">
                                    <div style="font-size: 1.8rem; font-weight: 800; color: var(--dark-emerald); margin-bottom: 8px;">${fileSize}</div>
                                    <div style="font-size: 0.9rem; color: var(--coffee-bean);">ميجابايت</div>
                                </div>
                                <div style="background: linear-gradient(135deg, var(--bright-gold-light) 0%, transparent 100%); padding: 20px; border-radius: 10px; border: 1px solid var(--bright-gold); text-align: center;">
                                    <div style="font-size: 1.8rem; font-weight: 800; color: var(--old-gold); margin-bottom: 8px;">${fileType}</div>
                                    <div style="font-size: 0.9rem; color: var(--coffee-bean);">نوع الملف</div>
                                </div>
                                <div style="background: linear-gradient(135deg, var(--dusty-taupe-light) 0%, transparent 100%); padding: 20px; border-radius: 10px; border: 1px solid var(--dusty-taupe); text-align: center;">
                                    <div style="font-size: 1.8rem; font-weight: 800; color: var(--coffee-bean); margin-bottom: 8px;">${dimensionsText}</div>
                                    <div style="font-size: 0.9rem; color: var(--coffee-bean);">الأبعاد</div>
                                </div>
                            </div>
                        `;
                    };
                    img.src = e.target.result;
                };
                
                reader.readAsDataURL(file);
            } else {
                // Hide preview section if no file
                previewSection.style.display = 'none';
            }
        }
        
        // File input enhancement with Arabic
        document.getElementById('photo').addEventListener('change', function(e) {
            const fileName = e.target.files[0]?.name || 'لم يتم اختيار ملف';
            const fileInput = e.target;
            
            // Create a custom display for the selected file
            const display = document.createElement('div');
            display.innerHTML = `
                <strong style="color: var(--dark-emerald);">الملف المحدد:</strong> ${fileName}
                <br>
                <small style="color: var(--dusty-taupe);">انقر لاختيار ملف مختلف</small>
            `;
            
            // Remove any existing display
            const existingDisplay = fileInput.nextElementSibling;
            if (existingDisplay && existingDisplay.classList.contains('file-display')) {
                existingDisplay.remove();
            }
            
            display.classList.add('file-display');
            display.style.cssText = `
                margin-top: 15px;
                padding: 15px;
                background: linear-gradient(135deg, var(--dark-emerald-light) 0%, transparent 100%);
                border-radius: 10px;
                border-right: 4px solid var(--dark-emerald);
                text-align: right;
                color: var(--coffee-bean);
            `;
            
            fileInput.parentNode.appendChild(display);
            
            // Check form validity
            checkFormValidity();
        });
        
        // hCaptcha callbacks
        window.onCaptchaSuccess = function(response) {
            console.log('hCaptcha verified successfully');
            checkFormValidity();
        };
        
        window.onCaptchaExpired = function() {
            console.log('hCaptcha expired');
            document.getElementById('submitBtn').disabled = true;
        };
        
        // Check if all required fields are filled to enable submit button
        function checkFormValidity() {
            const studentNumber = document.getElementById('student_number').value.trim();
            const fileInput = document.getElementById('photo');
            const hcaptchaResponse = document.querySelector('[name="h-captcha-response"]')?.value || '';
            const submitBtn = document.getElementById('submitBtn');
            
            const hasFile = fileInput.files && fileInput.files.length > 0;
            const hasStudentNumber = studentNumber.length > 0;
            const hasCaptcha = hcaptchaResponse.length > 0;
            
            submitBtn.disabled = !(hasFile && hasStudentNumber && hasCaptcha);
        }
        
        // Add event listeners for form validation
        document.getElementById('student_number').addEventListener('input', checkFormValidity);
        
        // Form validation in Arabic
        document.getElementById('uploadForm').addEventListener('submit', function(e) {
            const studentNumber = document.getElementById('student_number').value.trim();
            const fileInput = document.getElementById('photo');
            const hcaptchaResponse = document.querySelector('[name="h-captcha-response"]')?.value || '';
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            
            if (!studentNumber) {
                alert('الرجاء إدخال رقم الطالب.');
                e.preventDefault();
                return;
            }
            
            if (!fileInput.files || fileInput.files.length === 0) {
                alert('الرجاء اختيار صورة.');
                e.preventDefault();
                return;
            }
            
            if (!hcaptchaResponse) {
                alert('الرجاء إكمال تحقق hCaptcha.');
                e.preventDefault();
                return;
            }
            
            // Show loading state in Arabic
            submitText.innerHTML = '<span class="loading-spinner"></span> جاري المعالجة...';
            submitBtn.disabled = true;
        });
        
        // Initialize by checking form validity
        checkFormValidity();
    </script>
</body>
</html>