<?php
// ajax/get_sections.php
require_once '../db.php';
header('Content-Type: application/json');

try {
    $college_id = isset($_GET['college_id']) ? (int)$_GET['college_id'] : 0;
    
    if ($college_id <= 0) {
        echo json_encode([]);
        exit;
    }
    
    $stmt = $mysqli1->prepare("SELECT id, name FROM sections WHERE parent = ? AND deleted_at IS NULL ORDER BY name");
    $stmt->bind_param('i', $college_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $sections = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    
    echo json_encode($sections);
    
} catch (Exception $e) {
    error_log("Error in get_sections.php: " . $e->getMessage());
    echo json_encode([]);
}