<?php
// check_student_id.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require 'db.php';
require 'helpers.php';

header('Content-Type: application/json');

if (!isset($_POST['student_id'])) {
    echo json_encode(['exists' => false]);
    exit;
}

$studentId = trim($_POST['student_id']);

$stmt = $mysqli1->prepare("SELECT id FROM students WHERE student_id = ? AND deleted_at IS NULL");
$stmt->bind_param("s", $studentId);
$stmt->execute();
$result = $stmt->get_result();

echo json_encode([
    'exists' => $result->num_rows > 0,
    'student_id' => $studentId
]);
?>