</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const countrySelect = document.getElementById('country_id');
  const stateSelect = document.getElementById('state_id');
  const localitySelect = document.getElementById('locality_id');

  countrySelect.addEventListener('change', function () {
    const countryId = this.value;
    fetch('get_states.php?country_id=' + countryId)
      .then(res => res.json())
      .then(data => {
        stateSelect.innerHTML = '<option value="">Select state</option>';
        data.forEach(state => {
          stateSelect.innerHTML += `<option value="${state.id}">${state.name}</option>`;
        });
        localitySelect.innerHTML = '<option value="">Select locality</option>';
      });
  });

  stateSelect.addEventListener('change', function () {
    const stateId = this.value;
    fetch('get_localities.php?state_id=' + stateId)
      .then(res => res.json())
      .then(data => {
        localitySelect.innerHTML = '<option value="">Select locality</option>';
        data.forEach(locality => {
          localitySelect.innerHTML += `<option value="${locality.id}">${locality.name}</option>`;
        });
      });
  });
});
</script>

</body>
</html>
