<?php
// get_sections.php
require 'db.php';
require 'helpers.php';

header('Content-Type: application/json');

if (isset($_GET['college_id'])) {
    $college_id = intval($_GET['college_id']);
    
    $stmt = $mysqli1->prepare("SELECT id, name FROM sections WHERE parent = ? AND deleted_at IS NULL ORDER BY name");
    $stmt->bind_param("i", $college_id);
    $stmt->execute();
    $sections = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    
    echo json_encode($sections);
} else {
    echo json_encode([]);
}
?>