<?php include 'header.php'; ?>
<!-- Cairo for Arabic -->
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
  :root {
    /* نظام ألوان جديد متوافق مع #e2a549, #31749e, #0b3565 */
    --primary-dark: #0b3565;        /* أزرق داكن */
    --primary: #31749e;             /* أزرق متوسط */
    --primary-light: #4a8ab4;       /* أزرق فاتح */
    --secondary: #e2a549;           /* ذهبي */
    --secondary-light: #f0c068;     /* ذهبي فاتح */
    --secondary-dark: #d49530;      /* ذهبي داكن */
    --accent-blue: #1a5b92;         /* أزرق للتأكيد */
    --accent-green: #2a8a6a;        /* أخضر مائل للأزرق */
    --accent-red: #c44d3c;          /* أحمر ترابي */
    --accent-purple: #6a5b9a;       /* بنفسجي مائل للأزرق */
    --accent-orange: #e78c3c;       /* برتقالي مشبع */
    --accent-cyan: #2a869e;         /* سماوي مائل للأخضر */
    --light-bg: #f5f7fa;
    --card-bg: #ffffff;
    --text-primary: #1c3a5c;
    --text-secondary: #5a6c7d;
    --border-light: #e0e6ed;
    --shadow-sm: 0 2px 8px rgba(11, 53, 101, 0.06);
    --shadow-md: 0 4px 12px rgba(11, 53, 101, 0.08);
    --shadow-lg: 0 8px 24px rgba(11, 53, 101, 0.12);
    --transition: all 0.3s ease;
  }

  body, h1, h2, h3, h4, h5, h6, p, a, button, label {
    font-family: 'Cairo', -apple-system, BlinkMacSystemFont, sans-serif;
  }

  body {
    background: linear-gradient(135deg, #f5f7fa 0%, #e8edf5 100%);
    min-height: 100vh;
    position: relative;
  }

  .bg-pattern {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: #f5f7fa;
    background-image: 
      radial-gradient(circle at 15% 20%, rgba(49, 116, 158, 0.05) 0%, transparent 40%),
      radial-gradient(circle at 85% 80%, rgba(226, 165, 73, 0.05) 0%, transparent 40%),
      linear-gradient(45deg, transparent 49%, rgba(11, 53, 101, 0.02) 50%, transparent 51%);
    z-index: -1;
  }

  /* حاوية رئيسية */
  .main-wrapper {
    width: 85%;
    max-width: 1400px;
    margin: 0 auto;
    padding: 2rem 0;
  }

  /* بطاقة الأدوار - تصميم حديث وأنيق */
  .role-card {
    background: var(--card-bg);
    border-radius: 16px;
    padding: 2rem 1.5rem;
    border: 1px solid var(--border-light);
    box-shadow: var(--shadow-md);
    transition: var(--transition);
    text-align: center;
    position: relative;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: space-between;
  }

  .role-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--shadow-lg);
    border-color: var(--primary);
  }

  /* شريط لوني علوي */
  .role-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--secondary), var(--primary), var(--primary-dark));
  }

  /* أيقونة البطاقة */
  .card-icon-wrapper {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary-dark), var(--primary));
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1.5rem;
    box-shadow: 0 6px 12px rgba(11, 53, 101, 0.15);
    transition: var(--transition);
  }

  .role-card:hover .card-icon-wrapper {
    transform: scale(1.05);
    background: linear-gradient(135deg, var(--secondary), var(--primary));
  }

  .card-icon {
    font-size: 2rem;
    color: white;
    transition: var(--transition);
  }

  /* عنوان البطاقة */
  .card-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 0.8rem;
    line-height: 1.4;
  }

  /* وصف البطاقة */
  .card-desc {
    color: var(--text-secondary);
    font-size: 0.95rem;
    line-height: 1.5;
    margin-bottom: 1.5rem;
    flex-grow: 1;
  }

  /* أزرار أنيقة ومتوسطة الحجم */
  .elegant-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: 600;
    font-size: 0.95rem;
    text-decoration: none;
    transition: var(--transition);
    border: none;
    width: 100%;
    max-width: 200px;
    position: relative;
    overflow: hidden;
  }

  /* تأثير زر الإدارة العليا */
  .btn-admin {
    background: linear-gradient(135deg, var(--primary-dark), var(--primary));
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-admin:hover {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(11, 53, 101, 0.2);
  }

  /* تأثير زر الكليات */
  .btn-college {
    background: linear-gradient(135deg, var(--primary), #4a8ab4);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-college:hover {
    background: linear-gradient(135deg, #4a8ab4, var(--primary));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(49, 116, 158, 0.2);
  }

  /* تأثير زر الوحدة الصحية */
  .btn-health {
    background: linear-gradient(135deg, var(--accent-red), #d66352);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-health:hover {
    background: linear-gradient(135deg, #d66352, var(--accent-red));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(196, 77, 60, 0.2);
  }

  /* تأثير زر البطاقة الجامعية */
  .btn-card {
    background: linear-gradient(135deg, var(--accent-orange), #f0a052);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-card:hover {
    background: linear-gradient(135deg, #f0a052, var(--accent-orange));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(231, 140, 60, 0.2);
  }

  /* تأثير زر الحسابات/المحاسب */
  .btn-accountant {
    background: linear-gradient(135deg, var(--accent-green), #3a9a7a);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-accountant:hover {
    background: linear-gradient(135deg, #3a9a7a, var(--accent-green));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(42, 138, 106, 0.2);
  }

  /* تأثير زر شؤون الطلاب */
  .btn-student-affairs {
    background: linear-gradient(135deg, var(--accent-purple), #7a6baa);
    color: white !important;
    border: 1px solid transparent;
  }

  .btn-student-affairs:hover {
    background: linear-gradient(135deg, #7a6baa, var(--accent-purple));
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(106, 91, 154, 0.2);
  }

  /* العنوان الرئيسي */
  .page-header {
    text-align: center;
    margin-bottom: 3rem;
  }

  .main-title {
    font-size: 2.5rem;
    font-weight: 800;
    color: var(--primary-dark);
    margin-bottom: 0.5rem;
    position: relative;
    display: inline-block;
  }

  .main-title::after {
    content: '';
    position: absolute;
    bottom: -10px;
    left: 50%;
    transform: translateX(-50%);
    width: 100px;
    height: 4px;
    background: linear-gradient(90deg, var(--secondary), var(--primary), var(--primary-dark));
    border-radius: 2px;
  }

  .subtitle {
    color: var(--text-secondary);
    font-size: 1.1rem;
    margin-top: 1.5rem;
  }

  /* شبكة البطاقات */
  .cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 2rem;
    margin-bottom: 3rem;
  }

  /* بطاقة الشعار */
  .logo-card {
    background: linear-gradient(135deg, rgba(11, 53, 101, 0.05), rgba(226, 165, 73, 0.05));
    border-radius: 16px;
    padding: 2rem;
    margin-bottom: 2rem;
    border: 1px solid rgba(49, 116, 158, 0.1);
    box-shadow: var(--shadow-sm);
    text-align: center;
  }

  .university-name {
    font-size: 1.8rem;
    color: var(--primary-dark);
    font-weight: 700;
    margin-bottom: 0.5rem;
  }

  .system-name {
    color: var(--secondary);
    font-weight: 600;
    font-size: 1.1rem;
  }

  /* قسم المعلومات */
  .info-section {
    background: linear-gradient(135deg, rgba(49, 116, 158, 0.05), rgba(226, 165, 73, 0.05));
    border-radius: 16px;
    padding: 1.5rem;
    margin-top: 2rem;
    border: 1px solid rgba(49, 116, 158, 0.1);
  }

  .info-title {
    color: var(--primary-dark);
    font-weight: 600;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }

  .info-text {
    color: var(--text-secondary);
    font-size: 0.95rem;
    line-height: 1.6;
  }

  /* تصميم متجاوب */
  @media (max-width: 1200px) {
    .main-wrapper {
      width: 90%;
    }
  }

  @media (max-width: 992px) {
    .cards-grid {
      grid-template-columns: repeat(2, 1fr);
    }
  }

  @media (max-width: 768px) {
    .main-wrapper {
      width: 95%;
    }
    
    .cards-grid {
      grid-template-columns: 1fr;
      gap: 1.5rem;
    }
    
    .main-title {
      font-size: 2rem;
    }
    
    .role-card {
      padding: 1.5rem 1rem;
    }
    
    .card-icon-wrapper {
      width: 70px;
      height: 70px;
    }
    
    .card-icon {
      font-size: 1.8rem;
    }
  }

  @media (max-width: 480px) {
    .main-title {
      font-size: 1.8rem;
    }
    
    .elegant-btn {
      padding: 0.65rem 1.2rem;
      font-size: 0.9rem;
    }
  }
</style>

<!-- Custom Font Style -->
<style>
  @font-face {
    font-family: 'AlJazeeraArabicBold';
    src: url('fonts/Al-Jazeera-Arabic-Bold.ttf') format('truetype');
    font-weight: bold;
    font-style: normal;
  }

  h1, h2, h3, h4, h5, h6 {
    font-family: 'AlJazeeraArabicBold', 'Cairo', sans-serif;
  }
</style>

<!-- خلفية -->
<div class="bg-pattern"></div>

<div class="container-fluid d-flex flex-column justify-content-center align-items-center py-4">

  <div class="main-wrapper">
    
    <!-- بطاقة الشعار والمعلومات -->
    <div class="logo-card">
      <h1 class="university-name">كلية النهرين</h1>
      <p class="system-name">نظام الإدارة المتكاملة - بوابة الدخول الموحدة</p>
    </div>

    <!-- شبكة البطاقات -->
    <div class="cards-grid">
      
      <!-- الإدارة العليا -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--primary-dark), var(--accent-blue));">
          <i class="fas fa-user-shield card-icon"></i>
        </div>
        <h3 class="card-title">الإدارة العليا</h3>
        <p class="card-desc">
          لوحة التحكم الرئيسية للإدارة العليا ومتابعة العمليات الإدارية والأكاديمية
        </p>
        <a href="unified_login.php?role=admin" class="elegant-btn btn-admin">
          <i class="fas fa-lock me-2"></i> دخول آمن
        </a>
      </div>
      
      <!-- إدارة الكلية -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--primary), var(--accent-blue));">
          <i class="fas fa-user-tie card-icon"></i>
        </div>
        <h3 class="card-title">إدارة الكلية</h3>
        <p class="card-desc">
          مكتب العميد، المسجل، ضابط التسجيل والامتحانات
        </p>
        <a href="committee_login.php?role=committee" class="elegant-btn btn-college">
          <i class="fas fa-chalkboard-teacher me-2"></i> دخول الكلية
        </a>
      </div>
      
      <!-- الوحدة الصحية -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-red), #d66352);">
          <i class="fas fa-heartbeat card-icon"></i>
        </div>
        <h3 class="card-title">الوحدة الصحية</h3>
        <p class="card-desc">
          نظام الكشف الطبي والمتابعة الصحية وإدارة السجلات الطبية
        </p>
        <a href="doctor_login.php" class="elegant-btn btn-health">
          <i class="fas fa-medkit me-2"></i> دخول طبي
        </a>
      </div>
      
      <!-- البطاقة الجامعية -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--secondary), var(--secondary-dark));">
          <i class="fas fa-id-badge card-icon"></i>
        </div>
        <h3 class="card-title">البطاقة الجامعية</h3>
        <p class="card-desc">
          نظام إدارة وإصدار البطاقات الجامعية للطلبة والعاملين في الكلية
        </p>
        <a href="card_login.php?role=card_printing" class="elegant-btn btn-card">
          <i class="fas fa-print me-2"></i> إصدار البطاقات
        </a>
      </div>

      <!-- الحسابات/المحاسب -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-green), #3a9a7a);">
          <i class="fas fa-file-invoice-dollar card-icon"></i>
        </div>
        <h3 class="card-title">الحسابات/المحاسب</h3>
        <p class="card-desc">
          نظام إدارة الحسابات المالية والمصروفات والرسوم الدراسية والإيرادات
        </p>
        <a href="accountant_login.php?role=accountant" class="elegant-btn btn-accountant">
          <i class="fas fa-money-check-alt me-2"></i> دخول مالي
        </a>
      </div>
      
      <!-- شؤون الطلاب -->
      <div class="role-card">
        <div class="card-icon-wrapper" style="background: linear-gradient(135deg, var(--accent-purple), #7a6baa);">
          <i class="fas fa-users card-icon"></i>
        </div>
        <h3 class="card-title">شؤون الطلاب</h3>
        <p class="card-desc">
          نظام إدارة شؤون الطلاب والمتابعة الأكاديمية والخدمات الطلابية
        </p>
        <a href="" class="elegant-btn btn-student-affairs">
          <i class="fas fa-user-graduate me-2"></i> دخول الطلاب
        </a>
      </div>
      
    </div>

    <!-- قسم المعلومات -->
    <div class="info-section">
      <h4 class="info-title">
        <i class="fas fa-info-circle" style="color: var(--secondary);"></i> معلومات هامة
      </h4>
      <p class="info-text">
        • يرجى استخدام حسابك الرسمي للدخول إلى النظام<br>
        • النظام متاح على مدار الساعة طوال أيام الأسبوع<br>
        • للحصول على المساعدة، يرجى التواصل مع الدعم الفني<br>
        • جميع البيانات محمية وفقًا لأنظمة الخصوصية والأمان
      </p>
    </div>

  </div>

</div>

<?php include 'footer.php'; ?>