// filters.js
document.addEventListener('DOMContentLoaded', function() {
  // تأثيرات تفاعلية للفلاتر
  const formInputs = document.querySelectorAll('.form-input, .form-select');
  const applyBtn = document.querySelector('.btn-apply');
  
  // تأثير focus للعناصر
  formInputs.forEach(input => {
    input.addEventListener('focus', function() {
      this.parentElement.style.transform = 'translateY(-2px)';
    });
    
    input.addEventListener('blur', function() {
      this.parentElement.style.transform = 'translateY(0)';
    });
  });
  
  // تأثير للزر تطبيق
  if (applyBtn) {
    applyBtn.addEventListener('click', function(e) {
      this.style.transform = 'scale(0.95)';
      setTimeout(() => {
        this.style.transform = 'scale(1)';
      }, 150);
    });
  }
  
  // تأثير إزالة الفلتر
  const removeTags = document.querySelectorAll('.tag-remove');
  removeTags.forEach(tag => {
    tag.addEventListener('click', function(e) {
      e.preventDefault();
      const tagElement = this.parentElement;
      tagElement.style.animation = 'slideOut 0.3s ease forwards';
      
      setTimeout(() => {
        window.location.href = this.href;
      }, 300);
    });
  });
  
  // إضافة animation للخروج
  const style = document.createElement('style');
  style.textContent = `
    @keyframes slideOut {
      from {
        opacity: 1;
        transform: translateX(0);
      }
      to {
        opacity: 0;
        transform: translateX(10px);
      }
    }
  `;
  document.head.appendChild(style);
  
  // تأثير تغيير اللون عند الكتابة في البحث
  const searchInput = document.querySelector('.form-input[name="q"]');
  if (searchInput) {
    searchInput.addEventListener('input', function() {
      const searchIcon = this.parentElement.querySelector('i');
      if (this.value.length > 0) {
        searchIcon.style.color = '#3498db';
      } else {
        searchIcon.style.color = '#7f8c8d';
      }
    });
  }
});