// Form validation
(function() {
    'use strict';
    
    var forms = document.querySelectorAll('.needs-validation');
    
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            
            form.classList.add('was-validated');
        }, false);
    });
})();

// Phone validation - must start with 249 and have 9 more digits (12 total)
function validatePhone(input) {
    const phoneRegex = /^249\d{9}$/;
    if (phoneRegex.test(input.value)) {
        input.setCustomValidity('');
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
    } else {
        input.setCustomValidity('Phone must start with 249 followed by 9 digits (12 digits total)');
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
    }
}

function validatePhone2(input) {
    const phoneRegex = /^249\d{9}$/;
    if (phoneRegex.test(input.value)) {
        input.setCustomValidity('');
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
    } else {
        input.setCustomValidity('Phone must start with 249 followed by 9 digits (12 digits total)');
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
    }
}

function validateEmail(input) {
    const emailRegex = /^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$/i;
    if (emailRegex.test(input.value)) {
        input.setCustomValidity('');
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
    } else {
        input.setCustomValidity('Please enter a valid email address');
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
    }
}

function validateNationalId(input) {
    const idRegex = /^[0-9\-_]{11,}$/;
    if (idRegex.test(input.value)) {
        input.setCustomValidity('');
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
    } else {
        input.setCustomValidity('National ID must be at least 11 characters (numbers, dashes, or underscores)');
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
    }
}

// Real-time validation on input
document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone_number');
    const phone2Input = document.getElementById('phone_number2');
    const emailInput = document.getElementById('email');
    const nationalIdInput = document.getElementById('national_id');
    
    if (phoneInput) {
        phoneInput.addEventListener('input', function() { 
            validatePhone(this); 
            // Auto-format: ensure it starts with 249
            if (this.value && !this.value.startsWith('249')) {
                this.value = '249' + this.value.replace(/^249/, '');
            }
        });
    }
    
    if (phone2Input) {
        phone2Input.addEventListener('input', function() { 
            validatePhone2(this); 
            // Auto-format: ensure it starts with 249
            if (this.value && !this.value.startsWith('249')) {
                this.value = '249' + this.value.replace(/^249/, '');
            }
        });
    }
    
    if (emailInput) emailInput.addEventListener('input', function() { validateEmail(this); });
    if (nationalIdInput) nationalIdInput.addEventListener('input', function() { validateNationalId(this); });
});

// Add auto-format for phone numbers on page load
document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone_number');
    const phone2Input = document.getElementById('phone_number2');
    
    // Format existing phone numbers
    if (phoneInput && phoneInput.value && !phoneInput.value.startsWith('249')) {
        phoneInput.value = '249' + phoneInput.value;
        validatePhone(phoneInput);
    }
    
    if (phone2Input && phone2Input.value && !phone2Input.value.startsWith('249')) {
        phone2Input.value = '249' + phone2Input.value;
        validatePhone2(phone2Input);
    }
});