<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class ApiHelper
{
    /**
     * @throws \Exception
     */
    public static function hasAppAccount($studentId)
    {
        $port = env('APP_ACCOUNT_CHECK_PORT');

        if (empty($port)) {
            Log::error('APP_ACCOUNT_CHECK_PORT is not set');
            return false;
        }

        $response = Http::post("http://62.164.219.146:{$port}/api/auth/login", [
            'phoneNumber' => 'integrations',
            'password' => '-oh[jPME61[6<Rp_+11`w.J2',
        ]);

        if ($response->successful()) {
            $token = $response['token'];

            // Make another request with Authorization header
            $secondResponse = Http::withToken($token)
                ->get("http://62.164.219.146:{$port}/api/students/RegistrationStatus?AdmissionFormNoOrStudentNumber=" . $studentId);

            if ($secondResponse->successful()) {
                return $secondResponse['isERegistrationComplete'];
            }

            return $secondResponse;
        }

        Log::error('System login failed', [
            'status' => $response->status(),
            'body' => $response->body(),
        ]);

        throw new \Exception("System login failed: " . $response->body());
    }
}
