<?php

namespace App\Helpers;

use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image as InterventionImage;

class FileHelper
{

    public static function uploadFile($file, $studentId)
    {
        $fileExtension = $file->getClientOriginalExtension();

        $fileName = time() . "_" . substr(pathinfo($file, PATHINFO_FILENAME), 0, 10) . "." . $fileExtension;

        // $fileRealPath = $file->getRealPath();

        $fileSize = $file->getSize();

        $fileMimeType = $file->getMimeType();


        $path = 'files/students/';
        $studentFolder = str_replace('/', '_', $studentId);
        $fullPath = $path . $studentFolder . '/';

        if (!file_exists($fullPath)) {
            mkdir($fullPath, 0755);
        }

        if(static::fileIsImage($fileMimeType)){
            $image = InterventionImage::make($file->path());

            $image->backup();
            $image->resize(800, 800, function ($constraint) {
                $constraint->aspectRatio();
            });
            $quality = $fileSize > 600 ? 80 : 100;
            $image->save($fullPath . $fileName, $quality);
            $image->reset();

            return $studentFolder . "/" .$fileName;
        }

        $file->move($fullPath, $fileName);

        return $studentFolder . "/" .$fileName;
    }

    public static function deleteOldFile($path, $imageName, $model)
    {
        if( file_exists( public_path() . $path . $imageName ) ){
            static::deleteFile($path, $imageName, $model);

        } else {
            return false;
        }
    }

    public static function deleteFile($path, $imageName, $model)
    {
        File::delete(public_path() . $path . $imageName);

        if($model->files) {
            $file = $model->files->where('url', " = " , $imageName)->first();

            if($file){
                $file->delete();
                return true;
            }
        }

        return true;
    }

    public static function fileIsImage($fileMimeType)
    {
        $imageMimeTypes = ['image/jpeg','image/gif','image/png','image/bmp','image/svg+xml'];

        if (in_array($fileMimeType, $imageMimeTypes)){
            return true;
        } else {
            return false;
        }
    }
}
