<?php
namespace App\Helpers; // Your helpers namespace 

use App\Models\AcademicYear;
use App\Models\College;
use App\Models\Student;
use Illuminate\Http\Request;

class Helper
{
    public function filterStudents(Request $request)
    {
        $studentsPayments = Student::all();

        if ($request->has('filter')) {
            if ($request->filled('college_id') && $request->college_id != 0) {
                $students = College::find($request->college_id)->students;
            }
    
            if ($request->filled('section_id') && $request->section_id != 0) {
                $students = $students->where('section_id', $request->section_id);
            }
    
            if ($request->filled('program_id') && $request->program_id != 0) {
                $students = $students->where('program_id', $request->program_id);
            }
    
            if ($request->filled('batch_id') && $request->batch_id != 0) {
                 $students = $students->where('batch_id', $request->batch_id);
            }

            if ($request->filled('academic_year_id') && $request->academic_year_id != 0) {
                $academicYear = AcademicYear::find($request->academic_year_id);
                // return $academicYear;
                $students = $academicYear->students;
                return $students->count();
            }
        }

        return $studentsPayments;
    }
}