<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Log;

class LoggingHelper
{
    static function loginInfo($request)
    {
        Log::info(
            "Successful Login: " . PHP_EOL .
            "User email: " . $request->email . PHP_EOL .
            "Login time: " . now() . PHP_EOL .
            "Server IP: " . $request->ip() . PHP_EOL .
            "Client IP: " . static::getClientIp() . PHP_EOL
        );
    }

    static function logoutInfo($request)
    {
        Log::info(
            "Successful Logout: " . PHP_EOL .
            "User email: " . $request->email . PHP_EOL .
            "Login time: " . now() . PHP_EOL .
            "Server IP: " . $request->ip() . PHP_EOL .
            "Client IP: " . static::getClientIp() . PHP_EOL
        );
    }

    static function newPaymentRequestFail($request, $response)
    {
        Log::error(
            "New Payment request: " . PHP_EOL .
            "student ID: " . $request->student_id . PHP_EOL .
            "Payment Aamount: " . $request->payment_amount . PHP_EOL .
            "Payment Reference: " . $request->payment_reference . PHP_EOL .
            "Transaction Ref: " . $request->transaction_ref . PHP_EOL .
            "Semester_code: " . $request->semester_code . PHP_EOL .
            "Bank Identifier: " . $request->bank_identifier . PHP_EOL .
            "Bank ID: " . $request->bank_id . PHP_EOL .

            "Success: ". $response["success"] . PHP_EOL .
            "Message: ". $response["message"] . PHP_EOL .

            "Server IP: " . $request->ip() . PHP_EOL .
            "Client IP: " . static::getClientIp() . PHP_EOL .
            "Process Time: " . now() . PHP_EOL
        );
    }

    static function successfulPayment($request)
    {
        Log::info(
            "Successful Payment: " . PHP_EOL .
            "student ID" . $request->student_id . PHP_EOL .
            "Payment Aamount" . $request->payment_amount . PHP_EOL .
            "Payment Reference" . $request->payment_reference . PHP_EOL .
            "Transaction Ref" . $request->transaction_ref . PHP_EOL .
            "Semester_code" . $request->semester_code . PHP_EOL .
            "Bank Identifier" . $request->bank_identifier . PHP_EOL .
            "Bank ID" . $request->bank_id . PHP_EOL .

            "Process time: " . now() . PHP_EOL .
            "Server IP: " . $request->ip() . PHP_EOL .
            "Client IP: " . static::getClientIp() . PHP_EOL
        );
    }

    static function unsuccessfulPayment($request)
    {
        Log::info(
            "Unuccessful Payment: " . PHP_EOL .
            "Student ID: " . $request->student_id . PHP_EOL .
            "Payment Aamount: " . $request->payment_amount . PHP_EOL .
            "Payment Reference: " . $request->payment_reference . PHP_EOL .
            "Transaction Ref: " . $request->transaction_ref . PHP_EOL .
            "Semester_code: " . $request->semester_code . PHP_EOL .
            "Bank Identifier: " . $request->bank_identifier . PHP_EOL .
            "Bank ID: " . $request->bank_id . PHP_EOL .

            "Process time: " . now() . PHP_EOL .
            "Server IP: " . $request->ip() . PHP_EOL .
            "Client IP: " . static::getClientIp() . PHP_EOL
        );
    }

    static function getClientIp(){
        foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
            if (array_key_exists($key, $_SERVER) === true){
                foreach (explode(',', $_SERVER[$key]) as $ip){
                    $ip = trim($ip); // just to be safe
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false){
                        return $ip;
                    }
                }
            }
        }

        return request()->ip(); // it will return the server IP if the client IP is not found using this method.
    }
}
