<?php

namespace App\Helpers;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;

class StudentHelper
{
    public static function filterStudents(Collection $collection, $request): Collection
    {
        $filterableFields = [
            'college_id', 'section_id', 'program_id', 'admission_id',
            'batch_id', 'constraint_id', 'bank_id', 'payment_currency'
        ];

        foreach ($filterableFields as $field) {
            if ($request->filled($field) && $request->$field != 0) {
                $collection = $collection->where($field, $request->$field);
            }
        }

        return $collection;
    }

    public static function hasPenalty($registrationStart, $registrationEnd): int
    {
        $start = Carbon::parse($registrationStart);
        $end = Carbon::parse($registrationEnd);
        $lastDay = $start->copy()->addWeeks(4);
        $now = Carbon::now();

        $penalty = 0;
        $minPenalty = 2000;
        $maxPenalty = 6000;

        if ($now->between($start, $end) && $now->lt($lastDay)) {
            for ($week = 1; $week <= 4; $week++) {
                if ($now->gt($start->copy()->addDays(7 * $week))) {
                    $penalty += $minPenalty;
                }
            }
        } else {
            $penalty = $maxPenalty;
        }

        return $penalty;
    }
}
