<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\API\BaseController;
use App\Models\Batch;
use App\Models\College;
use App\Models\Payment;
use App\Models\Section;
use App\Models\Student;

class ReportController extends BaseController
{
    public function index()
    {
        return 'works';
    }

    public function payments(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'filter_by' => 'required',
            'from' => 'nullable',
            'to' => 'nullable'
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }

        $from = $request->from ? date('Y-m-d H:i:s', strtotime($request->from)) : null;
        $to = $request->to ? date('Y-m-d H:i:s', strtotime($request->to)) : null;
        
        if($request->filter_by == 'all'){
            if($from && $to){
                $payments = Payment::whereBetween('created_at', [$from, $to])->get();
            } else {
                $payments = Payment::all();
            }
        } else {
            $validator = Validator::make($request->all(), [
                'filter_by' => 'required',
                'filter_id' => 'required',
            ]);

            if($validator->fails()){
                return $this->sendError('Validation Error.', $validator->errors());       
            }

            if ($request->filter_by == 'student'){
                if($from && $to){
                    $payments = Payment::where('student_id', $request->filter_id)
                        ->whereBetween('created_at', [$from, $to])->get();
                } else {
                    $payments = Payment::where('student_id', $request->filter_id)->get();
                }
            } else if ($request->filter_by == 'bank'){
                if($from && $to){
                    $payments = Payment::where('bank_id', $request->filter_id)
                        ->whereBetween('created_at', [$from, $to])->get();
                } else {
                    $payments = Payment::where('student_id', $request->filter_id)->get();
                }
            } else if ($request->filter_by == 'college'){
                $students = College::find($request->filter_id)->students->pluck('student_id');

                if($from && $to){
                    $payments = Payment::whereIn('student_id' , $students)
                        ->whereBetween('created_at', [$from, $to])->get();
                } else {
                    $payments = Payment::whereIn('student_id' , $students)->get();
                }
            } else if ($request->filter_by == 'batch'){
                $students = Batch::find($request->filter_id)->students->pluck('student_id');

                if($from && $to){
                    $payments = Payment::whereIn('student_id' , $students)
                        ->whereBetween('created_at', [$from, $to])->get();
                } else {
                    $payments = Payment::whereIn('student_id' , $students)->get();
                }
            } else if ($request->filter_by == 'section'){
                $students = Section::find($request->filter_id)->students->pluck('student_id');

                if($from && $to){
                    $payments = Payment::whereIn('student_id' , $students)
                        ->whereBetween('created_at', [$from, $to])->get();
                } else {
                    $payments = Payment::whereIn('student_id' , $students)->get();
                }
            }
        }
        return $payments != '[]' ?
                $this->sendResponse($payments,'') :
                $this->sendError('No Recodes.', 'Not found', 404);
    }

    public function filterOptions()
    {
        $options = [
            '1' => 'all',
            '2' => 'student',
            '3' => 'bank',
            '4' => 'college',
            '5' => 'batch',
            '6' => 'section'
        ];

        return $this->sendResponse($options,'');
    }

}
