<?php

namespace App\Http\Controllers\API;

use App\Helpers\ApiHelper;
use App\Helpers\StudentHelper;
use App\Models\Bank;
use App\Models\Student;
use App\Models\Semester;
use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use App\Models\OtherFee;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class StudentController extends Controller
{
    public function studentInfo(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'student_id' => 'required',
            'bank_identifier' => 'required',
        ]);

        if ($validator->fails()) {
            return response(['errors' => $validator->errors()->all()], 422);
        }

        $bankIdentifier = Bank::where('bank_identifier', $request->bank_identifier)->first();

        if(!$bankIdentifier){
            return response(['success' => false, 'message' => "you are not authorized to perform this action",], 401);
        }

        $feeCode = substr($request->student_id, 0, 3);

        if($feeCode == 117) {
            return $this->otherFeeData($request);
        }

        $this->hasAppAccount($request->student_id);

        return $this->studentFeeData($request);

    }

    public function getStudentInfo(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'student_id' => 'required',
            'pass' => 'required',
        ]);

        if ($validator->fails()) {
            return response(['errors' => $validator->errors()->all()], 422);
        }

        $bankIdentifier = Bank::where('bank_identifier', $request->bank_identifier)->first();

        if($request->pass != "uofs@3@5@7"){
            return response(['success' => false, 'message' => "you are not authorized to perform this action",], 401);
        }

        $feeCode = substr($request->student_id, 0, 3);

        if($feeCode == 117) {
            return $this->otherFeeData($request);
        }

        return $this->studentFeeData($request);
    }

    public function otherFeeData($request)
    {
        $reference = $request->student_id;

        $fee = OtherFee::where(['reference' => $reference, 'is_paid' => 0])->first();

        if(!$fee) {
            return response()->json(['success' => "false", "message" => "this fee is paid"], 422);
        }
        $result['student_id'] = $fee->id;
        $result['student_name'] = $fee->name;
        $result['payment_amount'] = $fee->amount + $fee->stamp;
        $result['payment_reference'] = $fee->reference;
        $result['semester_code'] = "117th";
        $result['payment_currency'] = $fee->payment_currency ?? "SDG";

        return response()->json(['success' => true, 'data' => $result, 'message' => ""]);

    }

    public function studentFeeData($request)
    {
        $student = Student::with('college')->where('student_id', $request->student_id)->first();

        if(!$student){
            return response()->json(['success' => false, 'message' => "Student not found", 404]);
        }

        // chack if student is medically fit
        // $medicallyFit = $this->canPay($request->student_id);
        $medicallyFit = true;

        if( $medicallyFit != true ){
            return response(['success' => false, 'message' => "Student is not medically fit",], 442);
        }

        $registration = Registration::where(['student_id' => $student->student_id, 'is_paid' => 0 ])->orderBy('created_at', 'desc')->first();

        if(!$registration){
            return response(['success' => false, 'message' => "registration not set yet",], 404);
        }

        if( env('APP_ACCOUNT_CHECK') ) {
            try {
                $hasAppAccount = ApiHelper::hasAppAccount($request->student_id);

                if( !$hasAppAccount ) {
                    return response([
                        'success' => false,
                        'message' => env('APP_ACCOUNT_CHECK_MESSAGE', "You are not authorized to perform this action")
                    ], 401);
                } else if( $hasAppAccount['message'] ) {
                    return response([
                        'success' => false,
                        'message' => $hasAppAccount['message']
                    ], 404);
                }
            } catch (\Throwable $th) {

            }
        }

        $currentTime = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s'));

        if (!$currentTime->between($registration->start, $registration->end)) {
            return response(['success' => false, 'message' => "registration not started yet",], 442);
        } else {
            $penalty = $registration->penalty;
            $result['student_id'] = $registration->student_id;
            $result['student_name'] = $registration->student_name;
            $result['student_college'] = $student->college->name ?? 'لم يتم التحديد';
            $result['payment_amount'] = $registration->payment_amount;
            $result['payment_reference'] = $registration->payment_reference;
            $result['payment_currency'] = $registration->payment_currency ?? "SDG";
            $semesterCode =  Semester::where('id', $registration->semester_id)->first()['code'] ?? 'not-set';

            if($semesterCode == "not-set"){
                return response(['success' => false, 'message' => "student semester does not detected, please report to college registrar",], 442);
            }

            $result['semester_code'] = $semesterCode;

            return response()->json(['success' => true, 'data' => $result, 'message' => ""]);
        }
    }

    public function canPay($studentNumber)
    {
        $token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJuYW1lIjoiUGF5bWVudHMiLCJyb2xlIjoiQWRtaW4iLCJuYmYiOjE2NzE5Nzk2NDMsImV4cCI6MTk4NzU5ODg0MywiaWF0IjoxNjcxOTc5NjQzLCJpc3MiOiJodHRwOi8vc21hcnR2YWxseS5jb20vIiwiYXVkIjoiaHR0cDovL3NtYXJ0dmFsbHkuY29tLyJ9.VZ0jlTkfvbqS0FBrRy-PaYrzlHNuJHxwAvnxMp2vZ3k";

        $response = Http::withToken($token)->get('http://3.19.233.152/api/Students/Medical', [
            'AdmissionFormNoOrStudentNumber' => $studentNumber
        ]);

        if (!empty($response['isMedicallyFit'])) {
            return $response['isMedicallyFit'];
        } else {
            return false;
        }

    }

    public function hasAppAccount($studentId)
    {
        if( env('APP_ACCOUNT_CHECK') ) {
            $response = ApiHelper::hasAppAccount($studentId);

            if( $response == false ) {
                return response([
                    'success' => false,
                    'message' => env('APP_ACCOUNT_CHECK_MESSAGE', "You are not authorized to perform this action")
                ], 401);
            } else if( isset($response['message']) ) {
                return response([
                    'success' => false,
                    'message' => $response['message']
                ], 404);
            }
        }

        return false;
    }

}
