<?php

namespace App\Http\Controllers\Dashboard;

use Carbon\Carbon;
use App\Models\Bank;
use App\Models\User;
use App\Models\Student;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Activitylog\Models\Activity;

class ActivityLogController extends Controller
{
    public function index()
    {
        $activities = Activity::with(['user', 'bank'])
            ->where('created_at', 'like', date("Y-m-d")."%")->orderBy('created_at', 'desc')
            ->get();

        $log_names = json_decode(collect([["id"=> "1", "value"=> "طالب"],["id"=> "2", "value"=> "دفعية طالب"],["id"=> "3", "value"=> "سداد دفعية"]]) );
        $events = json_decode(collect([["id"=> "1", "value"=> "إضافة"],["id"=> "2", "value"=> "تعديل"],["id"=> "3", "value"=> "حذف"]]) );

        // return $log_names;
        return view('settings.activity-log', [
            'activities' => $activities,
            'log_names' => $log_names,
            'events' => $events,
        ]);
    }


    public function filterActivities(Request $request)
    {
        $activities = Activity::with(['user', 'bank'])->orderBy('created_at', 'desc')->get();

        if ($request->has('filter')) {
            if ($request->filled('log_name_id') && $request->log_name_id != 0) {
                if($request->log_name_id == 1){
                    $log_name = 'student';
                } elseif($request->log_name_id == 2){
                    $log_name = 'registration';
                } elseif ($request->log_name_id == 3){
                    $log_name = 'payment';
                }

                $activities = $activities->where('log_name', $log_name);
            }
    
            if ($request->filled('event_id') && $request->event_id != 0) {
                if($request->event_id == 1){
                    $event = 'created';
                } elseif($request->event_id == 2){
                    $event = 'updated';
                } elseif ($request->event_id == 3){
                    $event = 'deleted';
                }

                $activities = $activities->where('event', $event);
            }

            if ($request->filled('from') && $request->filled('from')) {
                $from = Carbon::parse($request->from)->startOfDay()->toDateTimeString();
                $to = Carbon::parse($request->to)->endOfDay()->toDateTimeString();
                $activities = $activities->whereBetween('created_at',[$from, $to]);
            }

        }
     
        $log_names = json_decode(collect([["id"=> "1", "value"=> "طالب"],["id"=> "2", "value"=> "دفعية طالب"],["id"=> "3", "value"=> "سداد دفعية"]]) );
        $events = json_decode(collect([["id"=> "1", "value"=> "إضافة"],["id"=> "2", "value"=> "تعديل"],["id"=> "3", "value"=> "حذف"]]) );
        
        $activities = $activities->take(500);
        
        foreach($activities as $activity){
            if($activity->log_name == "student") {
                if($activity->event == 'deleted'){
                    $activity['student_id'] = $activity->properties['old']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                } else {
                    $activity['student_id'] = $activity->properties['attributes']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                }

                $activity['user_name'] = $activity->user->name ?? 'قاعدة البيانات';
            } elseif($activity->log_name == 'registration') {
                
                if($activity->event == 'deleted'){
                    $activity['student_id'] = $activity->properties['old']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                } else {
                    $activity['student_id'] = $activity->properties['attributes']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                }

                $activity['user_name'] = $activity->user->name ?? 'قاعدة البيانات';
            } elseif($activity->log_name == 'payment') {
                if($activity->event == 'deleted'){
                    $activity['student_id'] = $activity->properties['old']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                    $activity['payment_amount'] = $activity->properties['old']['payment_amount'] ?? 0.0;
                } else {
                    $activity['student_id'] = $activity->properties['attributes']['student_id'] ?? 'لم يتم التحديد، رقم النشاط للمراجعة => ' . $activity->id ?? '';
                    $activity['payment_amount'] = $activity->properties['attributes']['payment_amount'] ?? 0.0;
                }

                $bank = Bank::find($activity->properties['attributes']['bank_id']);
                $activity['user_name'] = $bank->name ?? 'قاعدة البيانات';
            }
        }

        return view('settings.activity-log', [
            'activities' => $activities,
            'log_names' => $log_names,
            'events' => $events,

            'log_name_id' => $request->log_name_id,
            'event_id' => $request->event_id,
        ]);
    }
}
