<?php

namespace App\Http\Controllers\Dashboard;

use LoggingHelper;
use App\Models\Bank;
use App\Models\Payment;
use App\Models\Student;
use App\Models\OtherFee;
use App\Models\Semester;
use App\Models\OtherPayment;
use App\Models\Registration;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class AmarousPayController extends Controller
{
    public function paymentRequest(Request $request)
    {
        $request['semester_id'] = $request->semester_id ?? "117th";

        $validator = Validator::make($request->all(), [
            'student_id' => 'required',
            'payment_amount' => 'required',
            'payment_reference' => "required",
            'transaction_ref' => 'required',
            'semester_id' => 'required',
            'bank_id' => 'nullable',
        ]);

        if ($validator->fails()) {
            return response()->json("هذا المستخدم غير مخول باجراء العملية", 422);
        }

        $bankIdentifier = Bank::where('bank_identifier', '639188d21dcc0')->first();

        if(!$bankIdentifier){
            return response()->json("هذا المستخدم غير مخول باجراء العملية", 403);
            
        }
        
        $feeCode = substr($request->payment_reference, 0, 3);

        if($feeCode == 117) {
            return $this->otherFeePayment($request, $bankIdentifier);
        }

        return $this->studentFeePayment($request, $bankIdentifier);
    }

    public function getStudentInfo(Request $request)
    {

        $feeCode = substr($request->student_id, 0, 3);

        if($feeCode == 117) {
            return $this->otherFeeData($request);
        }

        return $this->studentFeeData($request);
    }

    public function otherFeeData($request)
    {
        $reference = $request->student_id;

        $fee = OtherFee::where(['reference' => $reference, 'is_paid' => 0])->first();

        if(!$fee) {
            return response()->json("this fee is paid", 422);
        }

        $result['student_id'] = $fee->id;
        $result['student_name'] = $fee->name;
        $result['payment_amount'] = $fee->amount;
        $result['payment_reference'] = $fee->reference;
        $result['semester_code'] = "117th";
        $result['payment_currency'] = $fee->payment_currency ?? "SDG";

        return response()->json($result, 200);

    }

    public function studentFeeData($request)
    {
        $student = Student::find($request->student_id);

        if(!$student){
            return response()->json('لم يتم العثور علي الطالب في السجلات', 404);
        }

        $result = Registration::where('student_id', $student->student_id)->latest()->first([
            'student_id', 'student_name', 'payment_amount', 'payment_reference', 'semester_id', 'is_paid','created_at'
        ]);

        if (!$result) {
            return response()->json('لم يتم اضافة دفعية للطالب!', 404);
        }
        
        $payment = Payment::where('payment_reference', $result->payment_reference)->first();
        
        $result['payment_status'] = $result->is_paid == 1 ? 'تم السداد' : 'لم يتم السداد';
        $result['payment_amount'] = $payment ? $payment->payment_amount : $result->payment_amount;
        $result['payment_reference'] = $payment ? $payment->payment_reference : $result->payment_reference;
        $result['semester_name'] = Semester::find($result->semester_id)->name ?? 'لم يتم التحديد';
        $result['createdAt'] = $payment ? date('Y-m-d', strtotime($payment->created_at)) : null;
        $result['transaction_ref'] = $payment ? $payment->transaction_ref : null;
        $result['user_name'] = 'بنــــك المزارع';

        return response()->json($result, 200);
    }
    
    public function otherFeePayment($request, $bankIdentifier)
    {
        $reference = $request->payment_reference;

        $fee = OtherFee::where(['reference' => $reference])->first();

        if(!$fee){
            $response = "fee not found";

            $this->writeLog($request, $response);

            return response($response, 404);
        }

        if($request->payment_amount < $fee->amount){
            return response("payment amount is less than required", 442);
        } else if($request->payment_amount > $fee->amount + $fee->stamp) {
            return response("payment amount is greater than required", 442);
        }

        if($fee->is_paid == 1){

            $response = "this fee is paid";

            $this->writeLog($request, $response);

            return response()->json($response, 442);
        }

        $otherPayment = new OtherPayment();

        $otherPayment['other_fee_id'] = $fee->id;
        $otherPayment['name'] = $fee->name;
        $otherPayment['phone_number'] = $fee->phone_number;
        $otherPayment['fee_type_id'] = $fee->fee_type_id;
        $otherPayment['reference'] = $request->payment_reference;
        $otherPayment['amount'] = $request->payment_amount;
        $otherPayment['payment_currency'] = $fee->payment_currency;
        $otherPayment['transaction_ref'] = $request->transaction_ref;
        $otherPayment['bank_id'] = $bankIdentifier->id;
        $otherPayment['stamp'] = $fee->stamp;

        $otherPayment->save();

        if ( !$otherPayment->save() && env('LOGGING_SYSTEM_ENABLED') == true ) {
            LoggingHelper::unsuccessfulPayment($request);
        }
        
        $fee->is_paid = 1;
        $fee->save();

        // $this->informMobileApp($payment['student_id'], $payment['semester_id'], $payment['payment_amount'], $payment['payment_reference'], $payment['created_at']);

        if (env('LOGGING_SYSTEM_ENABLED') == true) {
            LoggingHelper::successfulPayment($request);
        }

        // return response()->json(['success' => true, 'data' => "", 'message' => "Payment has been added succssfully",], 200);
        return response()->json($fee, 200);

    }

    public function studentFeePayment($request, $bankIdentifier)
    {
        $student = Student::where('student_id', $request->student_id)->first();

        if(!$student){
            return response()->json("لم يتم ايجاد هذا الطالب في السجلات", 404);
        }

        $semester = Semester::where('id', $request->semester_id)->first();

        if(!$semester){
            return response()->json("لم يتم ايجاد السمستر المعني في السجلات", 404);
        }
        
        $registration = Registration::where([ 'student_id' => $student->student_id, 'payment_reference' => $request->payment_reference, 'semester_id' => $semester->id ])->first();
        
        if(!$registration){
            return response()->json("لم يتم ايجاد هذه الدفعية في السجلات", 404);
        }
        
        $payment = new Payment();

        if($request->payment_amount < $registration->payment_amount){
            return response()->json("مقدار الدفعية اقل من المبلغ المطلوب", 422);
        } else if($request->payment_amount > $registration->payment_amount) {
            return response()->json("مقدار الدفعية اكبر من المبلغ المطلوب", 422);
        }

        if($registration->is_paid == 1){
            return response()->json($registration, 409);
        }

        $payment['student_id'] = $student->student_id;
        $payment['student_name'] = $student->student_name;

        $payment['payment_reference'] = $request->payment_reference;
        $payment['semester_id'] = $request->semester_id;
        $payment['payment_amount'] = $request->payment_amount;
        $payment['transaction_ref'] = $request->transaction_ref;
        
        $payment['bank_id'] = $bankIdentifier->id;
        $payment['fee_type_id'] = $registration->fee_type_id;
        
        $payment['study_fees'] = $registration->study_fees;
        $payment['registration_fees'] = $registration->registration_fees;
        $payment['insurance_fees'] = $registration->insurance_fees;
        $payment['discount'] = $registration->discount;
        
        $payment->save();

        $registration->is_paid = 1;
        $registration->save();
        
        $payment['semester_name'] = Semester::find($payment->semester_id)->name ?? 'لم يتم التحديد';
        $payment['user_name'] = 'بنــــك المزارع';
        

        return response()->json($payment, 200);
    }

    public function sendMessageNotification(Request $request)
    {
        $response = Http::get('https://smss.nilogy.com/app/gateway/gateway.php', [
            'sendmessage' => 1,
            'username' => 'sinnaruniversityapi',
            'password' => 'sinnaruniversityapi#87',
            'sender' => 'Sinnar Univ',
            'numbers' => $request->phone_number,
            'text' => "تم انشاء دفعية باسم " ." ". $request->student_name ." ". "بالمبلغ " ." ". $request->amount . ", رقم الدفعية ". " (" . $request->payment_reference . ") " . "بتاريخ إنشاء " ." ". date('Y-m-d', strtotime($request->created_at)),
        ]);

        return $response;
    }
}
