<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\UserHelper;
use App\Models\{Batch, College, Program, Section, Student};
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class AttendanceController extends Controller
{
    public function classesAttendanceSheet()
    {
        $user = auth()->user();
        $filters = UserHelper::getRequestFilters();
        $collegeId = UserHelper::getCollegeId($user, $filters);
        $students = UserHelper::userStudents($user, $filters, true, 30);

        return view('attendances.classes-attendance-sheet', [
            'printList'     => [],
            'students'      => $students,
            'colleges'      => UserHelper::userColleges($user),
            'programs'      => Program::all(),
            'batches'       => Batch::all(),
            'sections'      => UserHelper::userSections($collegeId),
            'newStudentId'  => UserHelper::generateRandomStudentId(),
            'filters'       => (object) $filters,
        ]);
    }

    public function examsAttendanceSheet()
    {
        $user = auth()->user();
        $filters = UserHelper::getRequestFilters();
        $collegeId = UserHelper::getCollegeId($user, $filters);
        $students = UserHelper::userStudents($user, $filters, true, 30, onlyRegistered: true);

        return view('attendances.exams-attendance-sheet', [
            'students'  => $students,
            'colleges'  => UserHelper::userColleges($user),
            'programs'  => Program::all(),
            'batches'   => Batch::all(),
            'sections'  => UserHelper::userSections($collegeId),
            'filters'   => (object) $filters,
        ]);
    }
}
