<?php

namespace App\Http\Controllers\Dashboard;

use Illuminate\Http\Request;
use App\Exports\StudentExport;
use App\Imports\StudentImport;
use App\Exports\StudentExportView;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\StudentPaymentExport;
use App\Imports\StudentPaymentImport;
use App\Exports\StudentPaymentExportView;


class ExportImportController extends Controller
{
    public function importStudent(Request $request) 
    {
        try {
            Excel::import(new StudentImport, $request->file('file')->store('files'));

            Toastr::success('تم إستيراد بيانات الطلاب بنجاح', 'معاملة ناجحة!', ["positionClass" => "toast-top-center"]);
            
        } catch (\Throwable $th) {
            if( $th->getMessage() == "Undefined array key 25" ){
                Toastr::error('بعض الحقول مفقودة، الرجاء التاكد من ان عدد الحقول الكلية 29 حقل.', 'معاملة غير ناجحة!', ["positionClass" => "toast-top-center"]);
                Log::info($th);
                
            } else{
                Toastr::error('لم يتم إستيراد بيانات الطلاب، يجيب أن لا يتكرر رقم الطالب.', 'معاملة غير ناجحة!', ["positionClass" => "toast-top-center"]);
                Log::info($th);
            }
        }

        return redirect()->route('student.index');
    }

    public function exportStudent() 
    {
        return Excel::download(new StudentExport, 'students.xlsx');
    }

    public function exportStudentsView() 
    {
        return Excel::download(new StudentExportView, 'students.xlsx');
    }

    public function exportStudentsPaymentsView() 
    {
        return Excel::download(new StudentPaymentExportView, 'students-payments.xlsx');
    }
    
    public function importStudentPayment(Request $request) 
    {
        Excel::import(new StudentPaymentImport, $request->file('file')->store('files'));    
        return redirect()->back()->with('success', 'All good!');
    }

    public function exportStudentPayment() 
    {
        return Excel::download(new StudentPaymentExport, 'students-payments.xlsx');
    }
}
