<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\FileHelper;
use App\Models\File;
use App\Models\Student;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Validator;

class FileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'file' => 'max:9216',
        ]);

        if ($validator->fails()) {
            Toastr::error("الرجاء إختيار ملف لا يتعدى حجمه 9 ميغا.", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        if(!$request->file('file')){
            Toastr::error("الرجاء ارفاق الملف المراد اضافته!", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $uploadedFilePath = FileHelper::uploadFile($request->file('file'), $request->student_id);

        $file = new File();
        $file->file_type_id = $request->file_type_id;
        $file->fileable_id = $request->student_id;
        $file->fileable_type = "App\Models\Student";
        $file->note = $request->note ?? 'لم يتم التحديد';
        $file->url = $uploadedFilePath;

        $file->save();

        Toastr::success( "تم إضافة الملف بنجاح", __('student.success'), ["positionClass" => "toast-top-center"]);

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $file = File::find($id);

        if(!$file){
            return response()->json("لم يتم ايجاد الملف", 404);
        }

        return response()->json($file, 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $student = Student::where('student_id', $request->student_id)->first();

        $file = File::find($request->id);

        if(!$file) {
            Toastr::error("لم يتم إيجاد ملف الطالب", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        if($request->file('file_edit')){
            $this->deleteOldFile($file->url);

            $uploadedFilePath = FileHelper::uploadFile($request->file('file_edit'), $student->student_id);

            $file->url = $uploadedFilePath;
        }

        $file->file_type_id = $request->file_type_id;
        $file->fileable_id = $request->student_id;
        $file->fileable_type = "App\Models\Student";
        $file->note = $request->note;

        $file->save();

        Toastr::success( "تم تعديل الملف بنجاح", __('student.success'), ["positionClass" => "toast-top-center"]);

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $file = File::find($id);

        if(!$file) {
            return "not found";
        }

        if (file_exists( $deletedFile = public_path() . '/files/students/' . $file->url ?? 'no-file')) {
            @unlink($deletedFile);
        }

        $file->delete();

        Toastr::success( "تم حذف الملف بنجاح", __('student.success'), ["positionClass" => "toast-top-center"]);

        return redirect()->back();
    }

    public function deleteOldFile($url)
    {
        if (file_exists( $deletedFile = public_path() . '/files/students/' . $url ?? 'no-file')) {
            @unlink($deletedFile);
        }

        return true;
    }

}
