<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\FeeType;
use App\Models\OtherFee;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class OtherFeeController extends Controller
{
//    public function index()
//    {
//        $fees = OtherFee::with('feeType')->get();
//        $feeTypes = FeeType::all()
//            ->splice(1);
//
//        return view('fees.other-fees', [
//            'feeTypes' => $feeTypes,
//            'fees' => $fees,
//        ]);
//    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response|\Illuminate\View\View
     */
    public function index()
    {
        // Paginate other fees with their associated fee type
        $fees = OtherFee::with('feeType')->paginate(10);

        // Get all fee types except the first one
        $feeTypes = FeeType::all()->slice(1)->values();

        return view('fees.other-fees', [
            'feeTypes' => $feeTypes,
            'fees'     => $fees,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return void
     */
    public function create(){}


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'              => 'required',
            'phone_number'      => 'required',
            'fee_type_id'       => 'required',
            'payment_currency'  => 'required',
            'amount'            => 'nullable|numeric',
        ]);

        // Default stamp value
        $stamp = $request->stamp ?? 50;

        $fee = new OtherFee([
            'name'              => $request->name,
            'phone_number'      => $request->phone_number,
            'fee_type_id'       => $request->fee_type_id,
            'amount'            => ($request->amount ?? 0) + $stamp,
            'stamp'             => $stamp,
            'reference'         => $request->reference,
            'user_id'           => auth()->id(),
            'payment_currency'  => $request->payment_currency,
            'is_paid'           => 0,
        ]);

        $fee->save();

        if($fee->save()){
            // $this->sendMessageNotification($fee);
        }

        Toastr::success("تم اضافة الدفعية بنجاح", "عملية ناجحة", [
            "positionClass" => "toast-top-center"
        ]);

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $fee = OtherFee::find($id);

        if (!$fee) {
            return response()->json([
                'message' => 'لم يتم إيجاد الدفعية في سجلاتنا',
            ], 404);
        }

        return response()->json($fee, 200);
    }


    public function edit($id){}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name'              => 'required',
            'phone_number'      => 'required',
            'fee_type_id'       => 'required',
            'payment_currency'  => 'required',
            'amount'            => 'nullable|numeric',
        ]);

        $fee = OtherFee::find($id);

        if (!$fee) {
            Toastr::error("لم يتم ايجاد الدفعية في سجلاتنا، الرجاء مراجعة البيانات المدخلة", "عملية غير ناجحة", [
                "positionClass" => "toast-top-center"
            ]);
            return redirect()->back();
        }

        $fee->update([
            'name'              => $request->name,
            'phone_number'      => $request->phone_number,
            'fee_type_id'       => $request->fee_type_id,
            'payment_currency'  => $request->payment_currency,
            'amount'            => $request->amount,
            'stamp'             => $request->stamp ?? 50,
        ]);

        Toastr::success("تم تعديل الدفعية بنجاح", "عملية ناجحة", [
            "positionClass" => "toast-top-center"
        ]);

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $fee = OtherFee::find($id);

        if (!$fee) {
            return response()->json([
                'message' => 'لم يتم إيجاد الدفعية في سجلاتنا',
            ], 404);
        }

        $fee->delete();

        return response()->json([
            'message' => 'تم حذف الدفعية بنجاح',
        ], 200);
    }

    public function sendMessageNotification($fee)
    {
        $message = sprintf(
            "تم انشاء دفعية باسم %s بالمبلغ %s، رقم الدفعية (%s) بتاريخ إنشاء %s",
            $fee->name,
            $fee->amount,
            $fee->reference,
            $fee->created_at->format('Y-m-d')
        );

        $response = Http::get('https://smss.nilogy.com/app/gateway/gateway.php', [
            'sendmessage' => 1,
            'username'    => config('services.sms.username'),
            'password'    => config('services.sms.password'),
            'sender'      => 'Sinnar Univ',
            'numbers'     => $fee->phone_number,
            'text'        => $message,
        ]);

        return $response;
    }

}
