<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\UserHelper;
use App\Http\Controllers\Controller;
use App\Models\Bank;
use App\Models\Batch;
use App\Models\College;
use App\Models\Payment;
use App\Models\Program;
use App\Models\Section;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PrintOutController extends Controller
{
    public function registrarPrintOut()
    {
        return view('print-out.registrar');
    }

    public function classesSheet(Request $request)
    {
        return $this->renderSheetView('print-out.classes-sheet', $request);
    }

    public function examsSheet(Request $request)
    {
        return $this->renderSheetView('print-out.exams-sheet', $request);
    }

    public function revenueMin()
    {
        return request()->all();
        // Get all banks
        $banks = Bank::all();

        // Get aggregated payment data by college and admission_id
        $paymentSums = Payment::with('student.college')
            ->select(
                'students.college_id',
                'students.admission_id',
                DB::raw('SUM(payments.study_fees) as total_study_fees'),
                DB::raw('SUM(payments.registration_fees) as total_registration_fees'),
                DB::raw('SUM(payments.insurance_fees) as total_insurance_fees'),
                DB::raw('SUM(payments.discount) as total_discount'),
                DB::raw('SUM(payments.penalty) as total_penalty'),
                DB::raw('SUM(payments.stamp) as total_stamp')
            )
            ->join('students', 'students.student_id', '=', 'payments.student_id')
            ->groupBy('students.college_id', 'students.admission_id')
            ->get();

        // Prepare a structure to accumulate data by college
        $collegeData = [];

        foreach ($paymentSums as $row) {
            $collegeId = $row->college_id;
            $admissionId = $row->admission_id;

            // Ensure default values exist
            if (!isset($collegeData[$collegeId])) {
                $collegeData[$collegeId] = [
                    'total_private_fees' => 0,
                    'total_not_private_fees' => 0,
                    'total_other_fees' => 0,
                    'total_registration_fees' => 0,
                    'total_insurance_fees' => 0,
                    'total_discount' => 0,
                    'total_penalty' => 0,
                    'total_stamp' => 0,
                ];
            }

            // Categorize study_fees by admission type
            if ($admissionId == 2) {
                $collegeData[$collegeId]['total_private_fees'] += $row->total_study_fees;
            } elseif ($admissionId == 101) {
                $collegeData[$collegeId]['total_other_fees'] += $row->total_study_fees;
            } else {
                $collegeData[$collegeId]['total_not_private_fees'] += $row->total_study_fees;
            }

            // Accumulate other fees
            $collegeData[$collegeId]['total_registration_fees'] += $row->total_registration_fees;
            $collegeData[$collegeId]['total_insurance_fees'] += $row->total_insurance_fees;
            $collegeData[$collegeId]['total_discount'] += $row->total_discount;
            $collegeData[$collegeId]['total_penalty'] += $row->total_penalty;
            $collegeData[$collegeId]['total_stamp'] += $row->total_stamp;
        }

        // Load all colleges and attach the aggregated data as dynamic attributes
        $colleges = College::all()->map(function ($college) use ($collegeData) {
            $data = $collegeData[$college->id] ?? [
                'total_private_fees' => 0,
                'total_not_private_fees' => 0,
                'total_other_fees' => 0,
                'total_registration_fees' => 0,
                'total_insurance_fees' => 0,
                'total_discount' => 0,
                'total_penalty' => 0,
                'total_stamp' => 0,
            ];

            foreach ($data as $key => $value) {
                $college->$key = $value; // Dynamically attach the attribute to the College model
            }

            return $college;
        });

        return view('print-out.revenue-min', [
            'colleges' => $colleges,
            'banks' => $banks,
        ]);
    }


    private function renderSheetView(string $viewName, Request $request)
    {
        $user = auth()->user();
        $filters = UserHelper::getRequestFilters();
        $collegeId = UserHelper::getCollegeId($user, $filters);
        $students = UserHelper::userStudents($user, $filters, false);

        $collegeName = optional(College::find($collegeId))->name;
        $batchValue = optional(Batch::find($request->batch_id))->value;
        $sectionName = optional(Section::find($request->section_id))->name;
        $programName = optional(Program::find($request->program_id))->name;

        return view($viewName, compact(
            'students',
            'collegeName',
            'batchValue',
            'sectionName',
            'programName'
        ));
    }
}
