<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\UserHelper;
use App\Models\Batch;
use App\Models\Program;
use App\Models\Registration;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\College;
use App\Models\RegistrationConstraint;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx\Rels;

class RegistrationConstraintController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $registrations = RegistrationConstraint::with(['college', 'batch'])->paginate(10);

        return view('settings.registration-constraint', [
            'registrations' => $registrations,
            'colleges'      => College::all(),
            'programs'      => Program::all(),
            'batches'       => Batch::all(),
        ]);
    }

    public function create(){}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $constraint = new RegistrationConstraint();

        $constraint->college_id = $request->college_id;
        $constraint->batch_id = $request->batch_id;
        $constraint->start = $request->registration_start;
        $constraint->end = $request->registration_end;

        $constraint->save();

        return redirect()->route('settings.registration.constraint')->with('success', 'Registration Constraint Added Successfully');

    }

//    /**
//     * Store a newly created resource in storage.
//     *
//     * @param  \Illuminate\Http\Request  $request
//     * @return \Illuminate\Http\RedirectResponse
//     */
//    public function store(Request $request)
//    {
//        $request->validate([
//            'college_id'          => 'required|exists:colleges,id',
//            'batch_id'            => 'required|exists:batches,id',
//            'registration_start'  => 'required|date',
//            'registration_end'    => 'required|date|after_or_equal:registration_start',
//        ]);
//
//        RegistrationConstraint::create([
//            'college_id' => $request->college_id,
//            'batch_id'   => $request->batch_id,
//            'start'      => $request->registration_start,
//            'end'        => $request->registration_end,
//        ]);
//
//        return redirect()
//            ->route('settings.registration.constraint')
//            ->with('success', 'تمت إضافة قيود التسجيل بنجاح');
//    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $constraint = RegistrationConstraint::find($id);

        $constraint->start = date('Y-m-d', strtotime($constraint->start));
        $constraint->end = date('Y-m-d', strtotime($constraint->end));

        if (!$constraint) {
            return response()->json('not found', 404);
        }

        return response()->json($constraint, 200);
    }

//    /**
//     * Display the specified resource.
//     *
//     * @param  int  $id
//     * @return \Illuminate\Http\JsonResponse
//     */
//    public function show($id)
//    {
//        $constraint = RegistrationConstraint::find($id);
//
//        if (!$constraint) {
//            return response()->json([
//                'message' => 'قيود التسجيل غير موجودة',
//            ], 404);
//        }
//
//        return response()->json([
//            'data' => $constraint,
//        ], 200);
//    }

    public function edit($id) {}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $constraint = RegistrationConstraint::find($request->id);

        if (!$constraint) {
            return response()->json('not found', 404);
        }

        $constraint->college_id = $request->college_id;
        $constraint->batch_id = $request->batch_id;
        $constraint->start = $request->registration_start;
        $constraint->end = $request->registration_end;

        $constraint->save();

        return redirect()->route('settings.registration.constraint')->with('success', 'Registration Constraint Updated Successfully');
    }

//    /**
//     * Update the specified resource in storage.
//     *
//     * @param  \Illuminate\Http\Request  $request
//     * @param  int  $id
//     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
//     */
//    public function update(Request $request, $id)
//    {
//        $constraint = RegistrationConstraint::find($id);
//
//        if (!$constraint) {
//            return response()->json(['message' => 'قيود التسجيل غير موجودة'], 404);
//        }
//
//        $request->validate([
//            'college_id'         => 'required|exists:colleges,id',
//            'batch_id'           => 'required|exists:batches,id',
//            'registration_start' => 'required|date',
//            'registration_end'   => 'required|date|after_or_equal:registration_start',
//        ]);
//
//        $constraint->update([
//            'college_id' => $request->college_id,
//            'batch_id'   => $request->batch_id,
//            'start'      => $request->registration_start,
//            'end'        => $request->registration_end,
//        ]);
//
//        return redirect()
//            ->route('settings.registration.constraint')
//            ->with('success', 'تم تعديل قيود التسجيل بنجاح');
//    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $constraint = RegistrationConstraint::find($id);

        if (!$constraint) {
            return response()->json('not found', 404);
        }

        $constraint->delete();

        return response()->json('Registration Constraint Deleted Successfully', 200);
    }

//    /**
//     * Remove the specified resource from storage.
//     *
//     * @param  int  $id
//     * @return \Illuminate\Http\JsonResponse
//     */
//    public function destroy($id)
//    {
//        $constraint = RegistrationConstraint::find($id);
//
//        if (!$constraint) {
//            return response()->json([
//                'message' => 'قيود التسجيل غير موجودة'
//            ], 404);
//        }
//
//        $constraint->delete();
//
//        return response()->json([
//            'message' => 'تم حذف قيد التسجيل بنجاح'
//        ], 200);
//    }

}
