<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\Penalty;
use App\Models\Student;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\TableSortBy;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Http;

class SettingsController extends Controller
{
    public function index()
    {
        dd('');
        return view('settings.index');
    }

    public function setupRegistration()
    {
        $registration = Settings::where('name', 'registration')->first();

        if (!$registration) {
            return response()->json('not found', 404);
        }

        return view('settings.setup-registration', [
            'registration' => $registration,
        ]);
    }

    public function postSetupRegistration(Request $request)
    {
        $registrationStart = Settings::where('name', 'registration_start')->first();
        $registrationEnd = Settings::where('name', 'registration_end')->first();
        $registrationPenaltyAmount = Settings::where('name', 'penalty_amount')->first();

        $registrationStart->value = date('Y-m-d H:i:s', strtotime($request->registration_start));
        $registrationEnd->value = date('Y-m-d H:i:s', strtotime($request->registration_end));
        $registrationPenaltyAmount->value = $request->penalty_amount;

        $registrationStart->save();
        $registrationEnd->save();
        $registrationPenaltyAmount->save();

        Toastr::success( __('settings.registration-started-message'), __('settings.success'), ["positionClass" => "toast-top-center"]);
        return redirect()->back();
    }

    public function activateRegistration($settingsName, Request $request)
    {
        $registration = Settings::where('name', $settingsName)->first();

        if(!$registration){

        }

        $data['start'] = date('Y-m-d H:i:s', strtotime($request->start));
        $data['end'] = date('Y-m-d H:i:s', strtotime($request->end));
        $data['status'] = 1;

        $registration->value =  $data;

        $registration->update();

        return response()->json('success', 200);
    }

    public function deactivateRegistration($settingsName, Request $request)
    {
        $registration = Settings::where('name', $settingsName)->first();

        if(!$registration){

        }

        $data['start'] = null;
        $data['end'] = null;
        $data['status'] = 0;

        $registration->value =  $data;

        $registration->update();

        return response()->json('success', 200);
    }

    public function setupPenalty()
    {
        $penalties = Penalty::all();

        return view('settings.setup-penalty', [
            'penalties' => $penalties,
        ]);
    }

    public function postPenalty(Request $request)
    {
        $studentsPhonesList = collect();
        $students = Student::all();

        foreach ($students as $student) {
            $studentFees = $student->fees()
                ->where(['parent' => 2, 'paid' => 0.0])
                ->wherePivot('payment_status', 0)
                ->get();
            $current_fee = $studentFees->first();
            if ($current_fee) {
                if($student->phone_number != null){
                    $studentsPhonesList->push($student->phone_number);
                }
            }
        }

        $penalty = new Penalty();
        $penalty->start = $request->penalty_start;
        $penalty->end = $request->penalty_end;
        $penalty->amount = $request->penalty_amount;

        $penalty->save();

        /* remove this comment to send message notification
        if($penalty->save()){
            $deadline = date('Y-m-d H:i:s', strtotime($penalty->start));
            foreach ($studentsPhonesList as $phoneNumber) {
                $this->sendMessageNotification($phoneNumber, $deadline, $penalty->amount);
            }
        }
        */

        return response()->json('success', 200);
    }

    public function editPenalty($penaltyId, Request $request)
    {
        $penalty = Penalty::find($penaltyId);

        if(!$penalty) {
            return response()->json('not found', 404);
        }

        $studentsPhonesList = collect();
        $students = Student::all();

        foreach ($students as $student) {
            $studentFees = $student->fees()
                ->where(['parent' => 2, 'paid' => 0.0])
                ->wherePivot('payment_status', 0)
                ->get();
            $current_fee = $studentFees->first();
            if ($current_fee) {
                if($student->phone_number != null){
                    $studentsPhonesList->push($student->phone_number);
                }
            }
        }

        $penalty->start = $request->penalty_start;
        $penalty->end = $request->penalty_end;
        $penalty->amount = $request->penalty_amount;

        $penalty->save();

        /* remove this comment to send message notification
        if($penalty->save()){
            $deadline = date('Y-m-d H:i:s', strtotime($penalty->start));
            foreach ($studentsPhonesList as $phoneNumber) {
                $this->sendMessageNotification($phoneNumber, $deadline, $penalty->amount);
            }
        }
        */

        return response()->json('success', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deletePenalty($penaltyId, Request $request)
    {
        $penalty = Penalty::find($request->penaltyId);

        if (!$penalty) {
            return response()->json('not found', 404);
        }
        $penalty->delete();

        return response()->json('success', 200);
    }

    public function sendMessageNotification($phoneNumber, $penaltyEndDate, $penaltyAmount)
    {
        $response = Http::get('https://smss.nilogy.com/app/gateway/gateway.php', [
            'sendmessage' => 1,
            'username' => 'safatcollage-api',
            'password' => 'safatcollage3api56',
            'sender' => 'SafatColleg',
            'numbers' => $phoneNumber,
            'text' => 'تم تفعيل نظام الغارامات, الرجاء المسارعة بالتسجيل قبل تاريخ ' . $penaltyEndDate. ', سيتم فرض غرامة مالية مقدارها '. $penaltyAmount .' في حال التأخر عن السداد لما بعد التاريخ المذكور, وشكراً. مسجل الكلية.'
        ]);

        return $response;
    }

    public function sortTable(Request $request)
    {
        $table = TableSortBy::where('table_name', 'students')->first();

        if(!$table){
            $table = new TableSortBy();
            $table->table_name = 'students';
        }

        $table->sort_by_name = $request->sort_by_name;
        $table->sort_by_id = $request->sort_by_id;

        $table->save();

        return response()->json($request, 200);
    }

    public function sortStudents()
    {
        return view('settings.sort-students');
    }

    public function updateSortStudents(Request $request)
    {
        return $request->all();
    }
}
