<?php

namespace App\Http\Controllers\Dashboard;

use App\Helpers\UserHelper;
use App\Models\Batch;
use App\Models\Program;
use App\Models\Student;
use App\Models\Semester;
use App\Models\StudentCard;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class StudentCardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response|\Illuminate\View\View
     */
    public function index()
    {
        $user = auth()->user();
        $filters = UserHelper::getRequestFilters();
        $collegeId = UserHelper::getCollegeId($user, $filters);
        $students = UserHelper::userStudents($user, $filters, true, 20);

        return view('students-cards.index', [
            'students'      => $students,
            'colleges'      => UserHelper::userColleges($user),
            'programs'      => Program::all(),
            'batches'       => Batch::all(),
            'sections'      => UserHelper::userSections($collegeId),
            'newStudentId'  => str_pad(rand(1, 99999999), 8, '0', STR_PAD_LEFT),
            'filters'       => (object) $filters,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id)
    {

        $studentCard = StudentCard::where('student_id', $request->student_id)->first();

        $student = Student::with('college', 'section', 'files')
        ->where('student_id', $request->student_id)->first();

        if(!$student){
            return response()->json("لم يتم ايجاد بطاقة الطالب في سجلاتنا", 404);
        }


        if(!$studentCard){
            $studentCard = collect();

            $studentCard['student_id'] = $student->student_id;
            $studentCard['student_name'] = $student->student_name;
            $studentCard['college_name'] = $student->college->name ?? '';
            $studentCard['section_name'] = $student->section->name ?? '';

        }

        $studentCard['college_name'] = $student->college->name ?? '';

        if($student->files != '[]'){
            $studentCard['student_image'] = $student->files->where('file_type_id', 1)->first()->url;
        } else {
            $studentCard['student_image'] = "avatar.png";
        }

        // $studentCard['student_image'] = $this->studentImage($student->student_id);

        return response()->json($studentCard, 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    /*
    public function filterStudentsCards(Request $request)
    {
        dd( $request->all());
        $students = UserHelper::userStudents(auth()->user());

        if ($request->has('filter')) {
            if ($request->filled('college_id') && $request->college_id != 0) {
                $students = $students->where('college_id', $request->college_id);
            }

            if ($request->filled('section_id') && $request->section_id != 0) {
                $students = $students->where('section_id', $request->section_id);
            }

            if ($request->filled('program_id') && $request->program_id != 0) {
                $students = $students->where('program_id', $request->program_id);
            }

            if ($request->filled('batch_id') && $request->batch_id != 0) {
                $students = $students->where('batch_id', $request->batch_id);
            }

        }

        $colleges = UserHelper::userColleges(auth()->user());

        $sections = UserHelper::userSections($request->college_id);

        return view('students-cards.index', [
            'colleges' => $colleges,
            'sections' => $sections,
            'programs' => Program::all(),
            'batches' => Batch::all(),
            'semesters' => Semester::all(),

            'college_id' => $request->college_id,
            'section_id' => $request->section_id,
            'program_id' => $request->program_id,
            'batch_id' => $request->batch_id,
            'students' => $students,

        ]);
    }

    public function filterReplaceLostCards(Request $request)
    {

        $token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJuYW1lIjoiUGF5bWVudHMiLCJyb2xlIjoiQWRtaW4iLCJuYmYiOjE2NzE5Nzk2NDMsImV4cCI6MTk4NzU5ODg0MywiaWF0IjoxNjcxOTc5NjQzLCJpc3MiOiJodHRwOi8vc21hcnR2YWxseS5jb20vIiwiYXVkIjoiaHR0cDovL3NtYXJ0dmFsbHkuY29tLyJ9.VZ0jlTkfvbqS0FBrRy-PaYrzlHNuJHxwAvnxMp2vZ3k";

        $response = Http::withToken($token)->get('http://3.19.233.152/api/cards');

        $results = json_decode($response);

        $students = collect();

        foreach ($results as $result) {
            $student = Student::find($result->student->studentNumber);
            if($student){
                $students->push($student);
            }
        }

        if ($request->has('filter')) {
            if ($request->filled('college_id') && $request->college_id != 0) {
                $students = $students->where('college_id', $request->college_id);
            }

            if ($request->filled('section_id') && $request->section_id != 0) {
                $students = $students->where('section_id', $request->section_id);
            }

            if ($request->filled('program_id') && $request->program_id != 0) {
                $students = $students->where('program_id', $request->program_id);
            }

            if ($request->filled('batch_id') && $request->batch_id != 0) {
                $students = $students->where('batch_id', $request->batch_id);
            }

        }

        $colleges = UserHelper::userColleges(auth()->user());

        $sections = UserHelper::userSections($request->college_id);

        return view('students-cards.replace-lost', [
            'colleges' => $colleges,
            'sections' => $sections,
            'programs' => Program::all(),
            'batches' => Batch::all(),
            'semesters' => Semester::all(),

            'college_id' => $request->college_id,
            'section_id' => $request->section_id,
            'program_id' => $request->program_id,
            'batch_id' => $request->batch_id,
            'students' => $students,

        ]);
    }
    */

    public function printCard(Request $request)
    {
        $studentCard = StudentCard::where('student_id', $request->student_id)->first();

        if(!$studentCard){
            $student = Student::with('college', 'section')
                ->where('student_id', $request->student_id)->first();

            if(!$student){
                return response()->json("لم يتم ايجاد بطاقة الطالب في سجلاتنا", 404);
            }

            $studentCard = new StudentCard();
            $studentCard['student_id'] = $student->student_id;
            $studentCard['student_name'] = $student->student_name;
            $studentCard['college_name'] = $student->college->name ?? '';
            $studentCard['section_name'] = $student->section->name ?? '';
            $studentCard['expire_date'] = $student->expire_date;

            $studentCard['back_prints'] = 1;
            $studentCard['front_prints'] = 1;
            $studentCard['number_of_print'] = 1;
            $studentCard['status'] = 1;


        } else {
            $studentCard['student_id'] = $request->student_id;
            $studentCard['student_name'] = $request->student_name;
            $studentCard['college_name'] = $request->college_name ?? '';
            $studentCard['section_name'] = $request->section_name ?? '';
            $studentCard['expire_date'] = $request->expire_date;

            $studentCard['front_prints'] += 1;
            $studentCard['back_prints'] += 1;
            $studentCard['number_of_print'] += 1;
            $studentCard['status'] = 1;
        }


        $studentCard->save();

        return response()->json("تم طباعة البطاقة وجهين", 200);
    }

    public function printCardFront(Request $request)
    {
        $studentCard = StudentCard::where('student_id', $request->student_id)->first();

        if(!$studentCard){
            $student = Student::with('college', 'section')
                ->where('student_id', $request->student_id)->first();

            if(!$student){
                return response()->json("لم يتم ايجاد بطاقة الطالب في سجلاتنا", 404);
            }

            $studentCard = new StudentCard();

            $studentCard['student_id'] = $student->student_id;
            $studentCard['student_name'] = $student->student_name;
            $studentCard['college_name'] = $student->college->name ?? '';
            $studentCard['section_name'] = $student->section->name ?? '';
            $studentCard['front_prints'] = 1;

        } else {
            $studentCard['student_id'] = $request->student_id;
            $studentCard['student_name'] = $request->student_name;
            $studentCard['college_name'] = $request->college_name;
            $studentCard['section_name'] = $request->section_name;
            $studentCard['front_prints'] += 1;

            if($studentCard['front_prints'] == $studentCard['back_prints']) {
                $studentCard['number_of_print'] += 1;
                $studentCard['status'] = 1;
            }
        }


        $studentCard->save();

        return response()->json("تم طباعة الواجهة الامامية فقط للبطاقة", 200);
    }

    public function printCardBack(Request $request)
    {
        $studentCard = StudentCard::where('student_id', $request->student_id)->first();

        return response()->json(($studentCard['back_prints'] + $studentCard['front_prints']) / 2, 200);
        /*
        if(!$studentCard){
            $student = Student::with('college', 'section')
                ->where('student_id', $request->student_id)->first();

            if(!$student){
                return response()->json("لم يتم ايجاد بطاقة الطالب في سجلاتنا", 404);
            }

            $studentCard = new StudentCard();

            $studentCard['expire_date'] = $request->expire_date;

            $studentCard['back_prints'] = 1;

        } else {
            $studentCard['expire_date'] = $request->expire_date;

            $studentCard['back_prints'] += 1;

            if($studentCard['back_prints'] == $studentCard['front_prints']) {
                $studentCard['number_of_print'] += 1;
                $studentCard['status'] = 1;
            }
        }


        $studentCard->save();

        return response()->json("تم طباعة الواجهة الخلفية فقط للبطاقة", 200);
        */
    }

    public function replaceLost()
    {
        $user = auth()->user();
        $filters = UserHelper::getRequestFilters();
        $collegeId = UserHelper::getCollegeId($user, $filters);
        $students = UserHelper::userStudents($user, $filters, true, 20);

        return view('students-cards.replace-lost', [
            'students'      => $students,
            'colleges'      => UserHelper::userColleges($user),
            'programs'      => Program::all(),
            'batches'       => Batch::all(),
            'sections'      => UserHelper::userSections($collegeId),
            'newStudentId'  => str_pad(rand(1, 99999999), 8, '0', STR_PAD_LEFT),
            'filters'       => (object) $filters,
        ]);
    }

    public function studentImage($studentId)
    {
        $token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJuYW1lIjoiUGF5bWVudHMiLCJyb2xlIjoiQWRtaW4iLCJuYmYiOjE2NzE5Nzk2NDMsImV4cCI6MTk4NzU5ODg0MywiaWF0IjoxNjcxOTc5NjQzLCJpc3MiOiJodHRwOi8vc21hcnR2YWxseS5jb20vIiwiYXVkIjoiaHR0cDovL3NtYXJ0dmFsbHkuY29tLyJ9.VZ0jlTkfvbqS0FBrRy-PaYrzlHNuJHxwAvnxMp2vZ3k";

        $response = Http::withToken($token)->get('http://3.19.233.152/api/students/id-photo', [
            'studentNumber' => $studentId
        ]);

        if (!empty($response['resourceAt'])) {
            return $response['resourceAt'];
        } elseif(!empty( $response['status'])) {
            return asset('img/card/avatar.png');
        } else {
            return asset('img/card/avatar.png');
        }
    }
}
