<?php

namespace App\Http\Controllers\Dashboard;

use FileHelper;
use App\Models\File;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();

        return View::make('laratrust::panel.users.index', [
            'users' => $users,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // 
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request;
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string'],
        ]);

        if ($validator->fails()) {
            Toastr::error( __('لم يتم اضافة المستخدم، الرجاء التاكد من البيانات المدخلة.'), __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $user = new User();
        $user['name'] = $request->name;
        $user['email'] = $request->email;
        $user['password'] = Hash::make($request->password);
        
        $user->save();

        Toastr::success( __('تم اضافة المستخدم بنجاح'), __('student.success'), ["positionClass" => "toast-top-center"]);
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);

        if(!$user){
            return response()->json('not found', 404);
        }

        return response()->json($user, 200);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'password' => ['required', 'string'],
        ]);

        if ($validator->fails()) {
            Toastr::error( __('لم يتم تعديل بيانات المستخدم، الرجاء التاكد من البيانات المدخلة.'), __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $user = User::find($request->user_id);

        if(!$user){
            return response()->json('لم يتم ايجاد المستخدم في سجلاتنا', 404);
        }

        if($request->email != $user->email) {
            $validator = Validator::make($request->only('email'), [
                'email' => ['string', 'email', 'max:255', 'unique:users'],
            ]);

            $user['email'] = $request->email;
        }

        if ($validator->fails()) {
            Toastr::error( __('لم يتم تعديل بيانات المستخدم، هذا الايميل مستخدم مسبقا.'), __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $user['name'] = $request->name;
        $user['password'] = $request->password ? Hash::make($request->password) : $user->password;

        $user->save();

        Toastr::success( __('تم تعديل بيانات المستخدم بنجاح'), __('student.success'), ["positionClass" => "toast-top-center"]);
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::find($id);

        if(!$user){
            return response()->json('لم يتم ايجاد المستخدم في سجلاتنا', 404);
        }

        $user->delete();

        return response()->json('تم حذف المستخدم بنجاح', 200);
    }

    public function profile()
    {
        $user = auth()->user();

        if($user->hasRole('registrar')){
            $user['roleName'] = 'مسجل كلية';

        } elseif($user->hasRole('financial')){
            $user['roleName'] = 'محاسب';

        } elseif($user->hasRole('admin')){
            $user['roleName'] = 'مدير';

        }else{
            $user['roleName'] = 'مستخدم';

        }

        $user['profileImage'] = $user->files->first()->url ?? '/no-image.png';

        return view('users.profile', [
            'user' => $user,
        ]);
    }

    public function updateProfile(Request $request)
    {
        if($request->password == null){
            Toastr::error( "الرجاء ادخال كلمة المرور الخاصة بك عند اجراء تعديل على صفحتك الشخصية.", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
        ]);

        if ($validator->fails()) {
            Toastr::error( __('لم يتم تعديل بيانات المستخدم، الرجاء التاكد من البيانات المدخلة.'), __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $user = User::find($request->id);

        if(!$user){
            Toastr::error( "هذا المستخدم غير موجود في سجلاتنا.", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        if(!Hash::check($request->password, $user->password)){
            Toastr::error( "كلمة المرور غير صحيحة، ادخل كلمة المرور الصحيحة الخاصة بك.", __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        if($request->email != $user->email) {
            $validator = Validator::make($request->only('email'), [
                'email' => ['string', 'email', 'max:255', 'unique:users'],
            ]);

            $user['email'] = $request->email;
        }

        if ($validator->fails()) {
            Toastr::error( __('لم يتم تعديل بيانات المستخدم، هذا الايميل مستخدم مسبقا.'), __('student.error'), ["positionClass" => "toast-top-center"]);
            return redirect()->back();
        }

        $user['name'] = $request->name ?? $user->name;

        $user['password'] = $request->new_password ? Hash::make($request->new_password) : $user->password;

        $user->save();


        if($request->file('file')){
            FileHelper::deleteOldFile('/files/users/', $request->oldFile, $user);

            $file = $request->file('file');

            $fileName = time()."_".$file->getClientOriginalName();
       
            $fileExtension = $file->getClientOriginalExtension();
            // $fileRealPath = $file->getRealPath();
            $fileSize = $file->getSize();
            // $fileMimeType = $file->getMimeType();

            $path = 'files/users/';

            $fullPath = $path . $user->id . '/';

            $file->move($fullPath, $fileName);

            $uploadedFilePath = $user->id ."/". $fileName;
            
            $file = new File();

            $file->file_type_id = 1;
            $file->fileable_id = $user->id;
            $file->fileable_type = "App\Models\User";
            $file->note = "تم التعديل من الملف الشخصي";
            $file->url = $uploadedFilePath;

            $file->save();
        }
        
        Toastr::success( "تم تعديل بيانات المستخدم بنجاح.", __('student.success'), ["positionClass" => "toast-top-center"]);
        return redirect()->back();
    }
}
