<?php

namespace App\Http\Controllers;

use App\Helpers\SystemHelper;
use App\Models\Payment;
use App\Models\Student;
use App\Models\StudentFee;
use App\Models\Registration;
use Illuminate\Http\Request;
use App\Models\StudentPayment;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Collection;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index()
    {
        $registerd = 0;
        $partiallyRegistered = 0;
        $unregisterd = 0;
        $totalAmount = 0;
        $totalPaid = 0;
        $totalUnpaid = 0;
        $totalIncome = 0;

        $user = auth()->user();
        $collegeId = $user->college_id;
        $isRegistrar = $user->hasRole('registrar');
        $isFinancialOrAdmin = $user->hasRole(['financial', 'admin']);

        // Caching student count to avoid repeated queries
        $cacheKey = $isRegistrar ? "students_count_{$collegeId}" : "students_count_all";
        $studentsNumber = cache()->remember($cacheKey, 600, function() use ($isRegistrar, $collegeId) {
            return $isRegistrar
                ? Student::where('college_id', $collegeId)->count()
                : Student::count();
        });

        /* need more optimiziation
        // Optimized Fees and Payments Query
        $fees = Registration::with(['payment:id,payment_amount,payment_reference'])
            ->when($isRegistrar, function ($query) use ($collegeId) {
                $query->whereHas('student', function ($q) use ($collegeId) {
                    $q->where('college_id', $collegeId);
                });
            })
            ->get(['id', 'payment_amount', 'payment_reference', 'student_id']);

        // Use pluck to optimize payments collection
        $paymentReferences = $fees->pluck('payment_reference')->toArray();
        $payments = Payment::whereIn('payment_reference', $paymentReferences)
            ->select('payment_reference', 'payment_amount')
            ->get()
            ->keyBy('payment_reference');

        // Calculate registration statuses more efficiently
        foreach ($fees as $fee) {
            $feeAmount = $fee->payment_amount;
            $paymentAmount = $payments[$fee->payment_reference]->payment_amount ?? 0;

            if ($paymentAmount == $feeAmount && $paymentAmount != 0) {
                $registerd++;
            } elseif ($paymentAmount > ($feeAmount / 2)) {
                $partiallyRegistered++;
            }
        }

        $unregisterd = $studentsNumber - ($registerd + $partiallyRegistered);

        // Financial summaries only if required
        if ($isFinancialOrAdmin) {
            // Use raw query to calculate totals in one go
            $financials = DB::table('payments')
                ->selectRaw('SUM(payment_amount) as totalPaid')
                ->selectRaw('SUM(CASE WHEN bank_id = 1 THEN payment_amount ELSE 0 END) as savingBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 2 THEN payment_amount ELSE 0 END) as fcbBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 3 THEN payment_amount ELSE 0 END) as nileBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 4 THEN payment_amount ELSE 0 END) as neleenBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 5 THEN payment_amount ELSE 0 END) as uofsfinancial')
                ->when($isRegistrar, function ($query) use ($collegeId) {
                    $query->whereHas('student', function ($q) use ($collegeId) {
                        $q->where('college_id', $collegeId);
                    });
                })
                ->first();

            $totalAmount = $fees->sum('payment_amount');
            $totalPaid = $financials->totalPaid ?? 0;
            $totalUnpaid = $totalAmount - $totalPaid;
            $totalIncome = $totalPaid;
        }
*/
        // Return view with minimal data transformation
        return view('home', [
            'studentsNumber' => $studentsNumber ?? 0,
            'registerdStudents' => $registerd,
            'unregisterdStudents' => $unregisterd,
            'partiallyRegisteredStudents' => $partiallyRegistered,
            'totalIncome' => $totalIncome,
            'totalPaid' => $totalPaid,
            'totalAmount' => $totalAmount,
            'totalUnpaid' => $totalUnpaid,
            'ssdBankRevenue' => $financials->savingBank ?? 0,
            'fcbSudanBankRevenue' => $financials->fcbBank ?? 0,
            'nbBankRevenue' => $financials->nileBank ?? 0,
            '_2nbBankRevenue' => $financials->neleenBank ?? 0,
            'uofsfinancial' => $financials->uofsfinancial ?? 0,
        ]);
    }
}
