<?php

namespace App\Http\Controllers;

use App\Helpers\SystemHelper;
use App\Models\Payment;
use App\Models\Student;
use App\Models\StudentFee;
use App\Models\Registration;
use Illuminate\Http\Request;
use App\Models\StudentPayment;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Collection;

class HomeControllerBackup extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     *//*
    public function index()
    {
        $registerd = 0;
        $partiallyRegistered = 0;
        $unregisterd = 0;

        $totalAmount = 0;
        $totalPaid = 0;
        $totalUnpaid = 0;
        $totalIncome = 0;


        if( auth()->user()->hasRole('registrar') ){
            $studentsNumber = Student::where('college_id', auth()->user()->college_id)->count();

            $fees = Registration::with(['student', 'student.payments'])->get();
            $fees = $fees->where('student.college_id', auth()->user()->college_id);

            $payments = Payment::with('student')->get();
            $payments = $payments->where('student.college_id', auth()->user()->college_id);

        } else {

            $studentsNumber = Student::all()->count();

            $fees = Registration::with(['student', 'payment'])->get();
            $payments = Payment::with(['student', 'bank'])->get();
        }

        foreach ($fees as $fee) {
            $feeAmount = $fee->payment_amount;

            if($fee->student && $fee->student->payments){
                // $paymentAmount = $fee->student->payments->where('payment_reference', $fee->payment_reference)->first()->payment_amount ?? -1;
                $paymentAmount = $fee->payment->payment_amount ?? -1;
            } else{
                $paymentAmount = 0;
            }

            if($paymentAmount == $feeAmount && $paymentAmount != 0){
                $registerd += 1;
            } else if ($paymentAmount != $feeAmount && $paymentAmount > ($feeAmount / 2) ) {
                $partiallyRegistered +=  1;
            }
        }

        $unregisterd = $studentsNumber - ($registerd + $partiallyRegistered);

        if( auth()->user()->hasRole(['financial', 'admin']) ){
            $totalAmount = $fees->sum('payment_amount');
            $totalPaid = $payments->sum('payment_amount');
            $totalUnpaid = $totalAmount - $totalPaid;
            $totalIncome = $payments->sum('payment_amount');
        }

        $savingBank = $payments->where('bank_id', 1)->sum('payment_amount');
        $fcbBank = $payments->where('bank_id', 2)->sum('payment_amount') ;
        $nileBank = $payments->where('bank_id', 3)->sum('payment_amount');
        $neleenBank = $payments->where('bank_id', 4)->sum('payment_amount');
        $uofsfinancial = $payments->where('bank_id', 5)->sum('payment_amount');

        return view('home', [
            'studentsNumber' => $studentsNumber ?? 0,
            'registerdStudents' => $registerd,
            'unregisterdStudents' => $unregisterd,
            'partiallyRegisteredStudents' => $partiallyRegistered,

            'totalIncome' => $totalIncome,
            'totalPaid' => $totalPaid,
            'totalAmount' => $totalAmount,
            'totalUnpaid' => $totalUnpaid,

            'ssdBankRevenue' => $savingBank,
            'fcbSudanBankRevenue' => $fcbBank,
            'nbBankRevenue' => $nileBank,
            '_2nbBankRevenue' => $neleenBank,
            'uofsfinancial' => $uofsfinancial,
        ]);
    }*/

    /* with 10+ seconds
    public function index()
    {
        $registerd = 0;
        $partiallyRegistered = 0;
        $unregisterd = 0;
        $totalAmount = 0;
        $totalPaid = 0;
        $totalUnpaid = 0;
        $totalIncome = 0;

        $user = auth()->user();
        $collegeId = $user->college_id;
        $isRegistrar = $user->hasRole('registrar');
        $isFinancialOrAdmin = $user->hasRole(['financial', 'admin']);

        // Caching student count to avoid repeated queries
        $cacheKey = $isRegistrar ? "students_count_{$collegeId}" : "students_count_all";
        $studentsNumber = cache()->remember($cacheKey, 600, function() use ($isRegistrar, $collegeId) {
            return $isRegistrar
                ? Student::where('college_id', $collegeId)->count()
                : Student::count();
        });

        // Optimized Fees and Payments Query
        $fees = Registration::with(['payment:id,payment_amount,payment_reference'])
            ->when($isRegistrar, function ($query) use ($collegeId) {
                $query->whereHas('student', function ($q) use ($collegeId) {
                    $q->where('college_id', $collegeId);
                });
            })
            ->get(['id', 'payment_amount', 'payment_reference', 'student_id']);

        // Use pluck to optimize payments collection
        $paymentReferences = $fees->pluck('payment_reference')->toArray();
        $payments = Payment::whereIn('payment_reference', $paymentReferences)
            ->select('payment_reference', 'payment_amount')
            ->get()
            ->keyBy('payment_reference');

        // Calculate registration statuses more efficiently
        foreach ($fees as $fee) {
            $feeAmount = $fee->payment_amount;
            $paymentAmount = $payments[$fee->payment_reference]->payment_amount ?? 0;

            if ($paymentAmount == $feeAmount && $paymentAmount != 0) {
                $registerd++;
            } elseif ($paymentAmount > ($feeAmount / 2)) {
                $partiallyRegistered++;
            }
        }

        $unregisterd = $studentsNumber - ($registerd + $partiallyRegistered);

        // Financial summaries only if required
        if ($isFinancialOrAdmin) {
            // Use raw query to calculate totals in one go
            $financials = DB::table('payments')
                ->selectRaw('SUM(payment_amount) as totalPaid')
                ->selectRaw('SUM(CASE WHEN bank_id = 1 THEN payment_amount ELSE 0 END) as savingBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 2 THEN payment_amount ELSE 0 END) as fcbBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 3 THEN payment_amount ELSE 0 END) as nileBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 4 THEN payment_amount ELSE 0 END) as neleenBank')
                ->selectRaw('SUM(CASE WHEN bank_id = 5 THEN payment_amount ELSE 0 END) as uofsfinancial')
                ->when($isRegistrar, function ($query) use ($collegeId) {
                    $query->whereHas('student', function ($q) use ($collegeId) {
                        $q->where('college_id', $collegeId);
                    });
                })
                ->first();

            $totalAmount = $fees->sum('payment_amount');
            $totalPaid = $financials->totalPaid ?? 0;
            $totalUnpaid = $totalAmount - $totalPaid;
            $totalIncome = $totalPaid;
        }

        // Return view with minimal data transformation
        return view('home', [
            'studentsNumber' => $studentsNumber ?? 0,
            'registerdStudents' => $registerd,
            'unregisterdStudents' => $unregisterd,
            'partiallyRegisteredStudents' => $partiallyRegistered,
            'totalIncome' => $totalIncome,
            'totalPaid' => $totalPaid,
            'totalAmount' => $totalAmount,
            'totalUnpaid' => $totalUnpaid,
            'ssdBankRevenue' => $financials->savingBank ?? 0,
            'fcbSudanBankRevenue' => $financials->fcbBank ?? 0,
            'nbBankRevenue' => $financials->nileBank ?? 0,
            '_2nbBankRevenue' => $financials->neleenBank ?? 0,
            'uofsfinancial' => $financials->uofsfinancial ?? 0,
        ]);
    }
*/
/*
public function index()
{
    // Temporary zero values for all parameters
    $studentsNumber = 0;
    $registerd = 0;
    $partiallyRegistered = 0;
    $unregisterd = 0;
    $totalAmount = 0;
    $totalPaid = 0;
    $totalUnpaid = 0;
    $totalIncome = 0;
    $savingBank = 0;
    $fcbBank = 0;
    $nileBank = 0;
    $neleenBank = 0;
    $uofsfinancial = 0;

    // Return view with all parameters set to zero
    return view('home', [
        'studentsNumber' => $studentsNumber,
        'registerdStudents' => $registerd,
        'unregisterdStudents' => $unregisterd,
        'partiallyRegisteredStudents' => $partiallyRegistered,
        'totalIncome' => $totalIncome,
        'totalPaid' => $totalPaid,
        'totalAmount' => $totalAmount,
        'totalUnpaid' => $totalUnpaid,
        'ssdBankRevenue' => $savingBank,
        'fcbSudanBankRevenue' => $fcbBank,
        'nbBankRevenue' => $nileBank,
        '_2nbBankRevenue' => $neleenBank,
        'uofsfinancial' => $uofsfinancial,
    ]);
}

*/

    /*
    public function index()
    {
        $user = auth()->user();
        $collegeId = $user->college_id;
        $isRegistrar = $user->hasRole('registrar');
        $isFinancialOrAdmin = $user->hasRole(['financial', 'admin']);

        // Fetch student count in one query
        $studentsNumber = Student::when($isRegistrar, fn($q) => $q->where('college_id', $collegeId))->count();

        // Get all payment and fee data in a single query
        $fees = DB::table('registrations as r')
            ->leftJoin('payments as p', 'r.payment_reference', '=', 'p.payment_reference')
            ->join('students as s', 'r.student_id', '=', 's.id')
            ->selectRaw("
            COUNT(r.id) as totalRegistrations,
            SUM(CASE WHEN p.payment_amount >= r.payment_amount AND p.payment_amount > 0 THEN 1 ELSE 0 END) as fullyRegistered,
            SUM(CASE WHEN p.payment_amount > (r.payment_amount / 2) AND p.payment_amount < r.payment_amount THEN 1 ELSE 0 END) as partiallyRegistered,
            SUM(r.payment_amount) as totalAmount,
            SUM(p.payment_amount) as totalPaid
        ")
            ->when($isRegistrar, fn($q) => $q->where('s.college_id', $collegeId))
            ->first();

        $registerd = $fees->fullyRegistered ?? 0;
        $partiallyRegistered = $fees->partiallyRegistered ?? 0;
        $unregisterd = $studentsNumber - ($registerd + $partiallyRegistered);
        $totalAmount = $fees->totalAmount ?? 0;
        $totalPaid = $fees->totalPaid ?? 0;
        $totalUnpaid = $totalAmount - $totalPaid;
        $totalIncome = $totalPaid;

        // Optimize financial queries
        if ($isFinancialOrAdmin) {
            $financials = DB::table('payments as p')
                ->join('students as s', 'p.student_id', '=', 's.id')
                ->selectRaw("
                SUM(p.payment_amount) as totalPaid,
                SUM(CASE WHEN p.bank_id = 1 THEN p.payment_amount ELSE 0 END) as savingBank,
                SUM(CASE WHEN p.bank_id = 2 THEN p.payment_amount ELSE 0 END) as fcbBank,
                SUM(CASE WHEN p.bank_id = 3 THEN p.payment_amount ELSE 0 END) as nileBank,
                SUM(CASE WHEN p.bank_id = 4 THEN p.payment_amount ELSE 0 END) as neleenBank,
                SUM(CASE WHEN p.bank_id = 5 THEN p.payment_amount ELSE 0 END) as uofsfinancial
            ")
                ->when($isRegistrar, fn($q) => $q->where('s.college_id', $collegeId))
                ->first();
        }

        return view('home', [
            'studentsNumber' => $studentsNumber,
            'registerdStudents' => $registerd,
            'unregisterdStudents' => $unregisterd,
            'partiallyRegisteredStudents' => $partiallyRegistered,
            'totalIncome' => $totalIncome,
            'totalPaid' => $totalPaid,
            'totalAmount' => $totalAmount,
            'totalUnpaid' => $totalUnpaid,
            'ssdBankRevenue' => $financials->savingBank ?? 0,
            'fcbSudanBankRevenue' => $financials->fcbBank ?? 0,
            'nbBankRevenue' => $financials->nileBank ?? 0,
            '_2nbBankRevenue' => $financials->neleenBank ?? 0,
            'uofsfinancial' => $financials->uofsfinancial ?? 0,
        ]);
    }
    */

//    public function index()
//    {
//        $registerd = 0;
//        $partiallyRegistered = 0;
//        $unregisterd = 0;
//        $totalAmount = 0;
//        $totalPaid = 0;
//        $totalUnpaid = 0;
//        $totalIncome = 0;
//
//        $user = auth()->user();
//        $collegeId = $user->college_id;
//        $isRegistrar = $user->hasRole('registrar');
//        $isFinancialOrAdmin = $user->hasRole(['financial', 'admin']);
//
//        // Cache student count (Avoid multiple queries)
//        $cacheKey = $isRegistrar ? "students_count_{$collegeId}" : "students_count_all";
//        $studentsNumber = cache()->remember($cacheKey, 600, function () use ($isRegistrar, $collegeId) {
//            return Student::when($isRegistrar, function ($query) use ($collegeId) {
//                return $query->where('college_id', $collegeId);
//            })->count();
//        });
//
//        // Fetch all necessary registration data in a single query
//        $fees = Registration::select('id', 'payment_amount', 'payment_reference', 'student_id')
//            ->when($isRegistrar, function ($query) use ($collegeId) {
//                $query->whereHas('student', function ($q) use ($collegeId) {
//                    $q->where('college_id', $collegeId);
//                });
//            })
//            ->with(['payment:id,payment_reference,payment_amount']) // Singular 'payment'
//            ->get();
//
//        // Use associative array for quick lookup
//        $payments = Payment::whereIn('payment_reference', $fees->pluck('payment_reference'))
//            ->pluck('payment_amount', 'payment_reference');
//
//        // Calculate registration statuses without iterating over all students
//        foreach ($fees as $fee) {
//            $paymentAmount = $payments[$fee->payment_reference] ?? 0;
//
//            if ($paymentAmount == $fee->payment_amount && $paymentAmount != 0) {
//                $registerd++;
//            } elseif ($paymentAmount > ($fee->payment_amount / 2)) {
//                $partiallyRegistered++;
//            }
//        }
//
//        $unregisterd = max(0, $studentsNumber - ($registerd + $partiallyRegistered));
//
//        // Financial Summary (Single Query Optimization)
//        if ($isFinancialOrAdmin) {
//            $financials = DB::table('payments')
//                ->selectRaw('
//                SUM(payment_amount) as totalPaid,
//                SUM(CASE WHEN bank_id = 1 THEN payment_amount ELSE 0 END) as savingBank,
//                SUM(CASE WHEN bank_id = 2 THEN payment_amount ELSE 0 END) as fcbBank,
//                SUM(CASE WHEN bank_id = 3 THEN payment_amount ELSE 0 END) as nileBank,
//                SUM(CASE WHEN bank_id = 4 THEN payment_amount ELSE 0 END) as neleenBank,
//                SUM(CASE WHEN bank_id = 5 THEN payment_amount ELSE 0 END) as uofsfinancial
//            ')
//                ->when($isRegistrar, function ($query) use ($collegeId) {
//                    return $query->whereExists(function ($q) use ($collegeId) {
//                        $q->select(DB::raw(1))
//                            ->from('students')
//                            ->whereColumn('students.id', 'payments.student_id')
//                            ->where('students.college_id', $collegeId);
//                    });
//                })
//                ->first();
//
//            // Use collection methods instead of recalculating
//            $totalAmount = $fees->sum('payment_amount');
//            $totalPaid = $financials->totalPaid ?? 0;
//            $totalUnpaid = max(0, $totalAmount - $totalPaid);
//            $totalIncome = $totalPaid;
//        }
//
//        // Return view with optimized data
//        return view('home', [
//            'studentsNumber' => $studentsNumber,
//            'registerdStudents' => $registerd,
//            'unregisterdStudents' => $unregisterd,
//            'partiallyRegisteredStudents' => $partiallyRegistered,
//            'totalIncome' => $totalIncome,
//            'totalPaid' => $totalPaid,
//            'totalAmount' => $totalAmount,
//            'totalUnpaid' => $totalUnpaid,
//            'ssdBankRevenue' => $financials->savingBank ?? 0,
//            'fcbSudanBankRevenue' => $financials->fcbBank ?? 0,
//            'nbBankRevenue' => $financials->nileBank ?? 0,
//            '_2nbBankRevenue' => $financials->neleenBank ?? 0,
//            'uofsfinancial' => $financials->uofsfinancial ?? 0,
//        ]);
//    }


/*
  $fees = Registration::select(
            'registrations.id',
            'registrations.payment_amount',
            'registrations.payment_reference',
            'registrations.student_id',
            DB::raw('COALESCE(payments.payment_amount, 0) as paid_amount')
        )
            ->leftJoin('payments', 'registrations.payment_reference', '=', 'payments.payment_reference')
            ->when($isRegistrar, function ($query) use ($collegeId) {
                $query->join('students', 'registrations.student_id', '=', 'students.id')
                    ->where('students.college_id', $collegeId);
            })
            ->get();

        // Use collection operations instead of extra DB queries
        $registerd = $fees->filter(fn($fee) => $fee->paid_amount == $fee->payment_amount && $fee->paid_amount != 0)->count();

        $partiallyRegistered = $fees->filter(fn($fee) => $fee->paid_amount > ($fee->payment_amount / 2) && $fee->paid_amount < $fee->payment_amount)->count();

        $unregisterd = $studentsNumber - ($registerd + $partiallyRegistered);
 */
}
