<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PaymentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'student_id' => $this->student_id,
            'student_name' => $this->student_name,
            'payment_reference' => $this->payment_reference,
            'semester_id' => $this->semester_id,
            'payment_amount' => $this->payment_amount,
            'transaction_ref' => $this->transaction_ref,
            'bank_id' => $this->bank_id,
            'fee_type_id' => $this->fee_type_id,
            'deleted_at' => $this->deleted_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'study_fees' => $this->study_fees,
            'registration_fees' => $this->registration_fees,
            'insurance_fees' => $this->insurance_fees,
            'discount' => $this->discount,
            'penalty' => $this->penalty,
            'stamp' => $this->stamp,
            'payment_currency' => $this->payment_currency,
            'constraint_id' => $this->constraint_id,
        ];
    }
}
