<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RegistrationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'student_id' => $this->student_id,
            'student_name' => $this->student_name,
            'payment_reference' => $this->payment_reference,
            'start' => $this->start,
            'end' => $this->end,
            'is_paid' => $this->is_paid,
            'fee_type_id' => $this->fee_type_id,
            'study_fees' => $this->study_fees,
            'registration_fees' => $this->registration_fees,
            'insurance_fees' => $this->insurance_fees,
            'discount' => $this->discount,
            'semester_id' => $this->semester_id,
            'payment_amount' => $this->payment_amount,
            'due_amount' => $this->due_amount,
            'user_id' => $this->user_id,
            'stamp' => $this->stamp,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'deleted_at' => $this->deleted_at,
            'payment_currency' => $this->payment_currency,
            'penalty' => $this->penalty,
        ];
    }
}
