<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'success' => true,
            'code' => 200,
            'data' => [
                'id' => $this->id,
                'student_id' => $this->student_id,
                'student_number' => $this->student_number,
                'student_name' => $this->student_name,
                'admission_degree' => $this->admission_degree,
                'gender' => $this->gender,
                'program_fees' => $this->program_fees,
                'registration_fees' => $this->registration_fees,
                'insurance_fees' => $this->insurance_fees,
                'discount' => $this->discount,
                'date_of_birth' => $this->date_of_birth,
                'phone_number' => $this->phone_number,
                'phone_number2' => $this->phone_number2,
                'email' => $this->email,
                'nationality' => $this->nationality,
                'guardian_phone_number' => $this->guardian_phone_number,
                'national_id' => $this->national_id,
                'college_id' => $this->college_id,
                'program_id' => $this->program_id,
                'section_id' => $this->section_id,
                'state_id' => $this->state_id,
                'admission_id' => $this->admission_id,
                'batch_id' => $this->batch_id,
                'admission_type' => $this->addmission_type,
                'admission_date' => $this->addmission_date,
                'admission_form_no' => $this->addmission_form_no,
                'certificate_type' => $this->certificate_type,
                'notes' => $this->notes,
                'excluded' => $this->excluded,
                'accommodation_type' => $this->accommodation_type,
                'acceptance_rate' => $this->acceptance_rate,
                'guardian_name' => $this->guardian_name,
                'guardian_address' => $this->guardian_address,
                'locality_id' => $this->locality_id,
                'payments' => PaymentResource::collection($this->payments),
                'registrations' => RegistrationResource::collection($this->registrations),
            ]
        ];
    }
}
