<?php

namespace App\Imports;

use App\Models\Student;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class StudentImport implements ToModel, WithHeadingRow
{
    /**
     * Map each row from the Excel sheet to the Student model
     *
     * @param array $row
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        return new Student([
            'student_id'            => $row['student_id'] ?? null,
            'student_number'        => $row['student_number'] ?? null,
            'student_name'          => $row['student_name'] ?? null,
            'admission_degree'      => $row['admission_degree'] ?? null,
            'gender'                => $row['gender'] ?? null,
            'program_fees'          => $row['program_fees'] ?? null,
            'registration_fees'     => $row['registration_fees'] ?? null,
            'insurance_fees'        => $row['insurance_fees'] ?? null,
            'discount'              => $row['discount'] ?? null,
            'date_of_birth'         => $row['date_of_birth'] ?? null,
            'phone_number'          => $row['phone_number'] ?? null,
            'phone_number2'         => $row['phone_number2'] ?? null,
            'email'                 => $row['email'] ?? null,
            'nationality'           => $row['nationality'] ?? null,
            'guardian_phone_number' => $row['guardian_phone_number'] ?? null,
            'national_id'           => $row['national_id'] ?? null,
            'college_id'            => $row['college_id'] ?? null,
            'program_id'            => $row['program_id'] ?? null,
            'section_id'            => $row['section_id'] ?? null,
            'state_id'              => $row['state_id'] ?? null,
            'admission_id'          => $row['admission_id'] ?? null,
            'batch_id'              => $row['batch_id'] ?? null,
            'addmission_type'       => $row['admission_type'] ?? null,
            'addmission_date'       => $row['admission_date'] ?? null,
            'addmission_form_no'    => $row['admission_form_no'] ?? null,
            'certificate_type'      => $row['certificate_type'] ?? null,
            'notes'                 => $row['notes'] ?? null,
            'created_at'            => $row['created_at'] ?? now(),
            'updated_at'            => $row['updated_at'] ?? now(),
        ]);
    }
}
