<?php

namespace App\Jobs;

use App\Models\Test;
use App\Models\Registration;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Carbon\Carbon;
use PhpParser\Node\Expr\FuncCall;

class IncreaseStudentPenalty implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
     
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $registrations = Registration::where('is_paid', 0)->get();
        $currentDate = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d H:i:s'));

        $minPenalty = 2000;
        $maxPenalty = 6000;

        foreach ($registrations as $registration) {
            $start = Carbon::parse($registration->start);
            $lastDay = Carbon::parse($registration->start)->addWeeks(4);
            
            if($currentDate->between($registration->start, $registration->end) && $currentDate < $lastDay){
                if ( $currentDate <= $start->addWeeks(1)) {
                    $registration->update(['penalty' => $minPenalty]);
                } elseif ( $currentDate >= $start->addWeeks(1) && $currentDate <= $start->addWeeks(2) ) {
                    $registration->update(['penalty' => $minPenalty * 2]);
                } else {
                    $registration->update(['penalty' => $minPenalty * 3]);
                }
            } else {
                $registration->update(['penalty' => $maxPenalty]);
            }

            static::calculatePaymentAmount($registration);
        }

    }

    public static function calculatePaymentAmount($registration)
    {
        // $sumOfFees = ( $registration->study_fees / 2 ) + ($registration->registration_fees + $registration->insurance_fees + $registration->stamp + $registration->penalty + $registration->due_amount) - $registration->discount;
        $sumOfFees = ( $registration->study_fees ) + ($registration->registration_fees + $registration->insurance_fees + $registration->stamp + $registration->penalty + $registration->due_amount) - $registration->discount;

        $registration->update(['payment_amount' => $sumOfFees]);
    }
}
