<?php

namespace App\Models;

use App\Models\OtherFee;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FeeType extends Model
{
    use HasFactory;

    /**
     * Get the otherFee that owns the FeeType
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function otherFee(): BelongsTo
    {
        return $this->belongsTo(OtherFee::class);
    }
}
