<?php

namespace App\Models;

use App\Models\FeeType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OtherFee extends Model
{
//    use HasFactory;

    protected $fillable = [
        'name',
        'phone_number',
        'fee_type_id',
        'amount',
        'stamp',
        'reference',
        'user_id',
        'payment_currency',
        'is_paid',
    ];
    /**
     * Get the feeType that owns the OtherFee
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function feeType(): BelongsTo
    {
        return $this->belongsTo(FeeType::class);
    }
}
