<?php

namespace App\Models;

use App\Models\Semester;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Registration extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;

    Protected $fillable = [
        'id',
        'student_id',
        'student_name',
        'payment_reference',
        'start',
        'end',
        'is_paid',
        'fee_type_id',
        'study_fees',
        'registration_fees',
        'insurance_fees',
        'discount',
        'semester_id',
        'payment_amount',
        'payment_currency',
        'due_amount',
        'user_id',
        'penalty',
        'created_at',
        'updated_at',
    ];

    /**
     * Get the student that owns the Registration
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    /**
     * Get the semester that owns the Payment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
     public function semester(): BelongsTo
    {
        return $this->belongsTo(Semester::class);
    }

    public function getActivitylogOptions(): LogOptions
    {
        // Chain fluent methods for configuration options
        return LogOptions::defaults()
        ->logFillable()
        ->useLogName('registration');
        // ->logOnly(['student_id', 'student_name']);
    }

    /**
     * Get the payment associated with the Registration
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function payment(): HasOne
    {
        return $this->hasOne(Payment::class, 'payment_reference', 'payment_reference');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class, 'payment_reference', 'payment_reference');
    }

    public function instalments(): HasMany
    {
        return $this->hasMany(FeeInstalment::class, 'fee_id', 'id');
    }
}
