<?php

namespace App\Models;

use App\Models\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Section extends Model
{
    use HasFactory;

    /**
     * Get all of the Students for the Section
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function Students(): HasMany
    {
        return $this->hasMany(Student::class, 'student_id');
    }
}