<?php

namespace App\View\Components;

use Illuminate\View\Component;

class InputField extends Component
{
    public string $label;
    public string $name;
    public ?string $id;
    public string $type;
    public $value;
    public string $placeholder;
    public bool $required;

    public function __construct(
        string $label,
        string $name,
        string $type = 'text',
        string $id = null,
               $value = '',
        string $placeholder = '',
        bool $required = false
    ) {
        $this->label = $label;
        $this->name = $name;
        $this->id = $id ?? $name;
        $this->type = $type;
        $this->value = $value;
        $this->placeholder = $placeholder ?: $label;
        $this->required = $required;
    }

    public function render()
    {
        return view('components.input-field');
    }
}
