<?php

namespace App\View\Components;

use Illuminate\View\Component;

class InputFieldFile extends Component
{
    public string $name;
    public ?string $id;
    public string $label;
    public ?string $accept;

    /**
     * @param string $name Input name
     * @param string|null $id Input ID
     * @param string $label Label text
     * @param string|null $accept Accepted file types (optional)
     */
    public function __construct(string $name, string $label, ?string $id = null, ?string $accept = null)
    {
        $this->name = $name;
        $this->id = $id ?? $name;
        $this->label = $label;
        $this->accept = $accept;
    }

    public function render()
    {
        return view('components.input-field-file');
    }
}
