<?php

namespace App\View\Components;

use Illuminate\View\Component;

class InputFieldRadio extends Component
{
    public string $label;
    public string $name;
    public array $options;
    public $selected;

    /**
     * Create a new component instance.
     *
     * @param string $label   The field label
     * @param string $name    Input name
     * @param array  $options Array of [value => text]
     * @param mixed  $selected Currently selected value
     */
    public function __construct(string $label, string $name, array $options = [], $selected = null)
    {
        $this->label = $label;
        $this->name = $name;
        $this->options = $options;
        $this->selected = $selected;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        return view('components.input-field-radio');
    }
}
