<?php

namespace App\View\Components;

use Illuminate\View\Component;

class InputFieldSelect extends Component
{
    public string $label;
    public string $name;
    public ?string $id;
    public iterable $options;
    public $selected;

    /**
     * @param string $label    Field label (e.g., "القسم")
     * @param string $name     Input name
     * @param iterable $options Options collection/array
     * @param mixed  $selected Selected value
     */
    public function __construct(string $label, string $name, iterable $options = [], $selected = null, ?string $id = null)
    {
        $this->label = $label;
        $this->name = $name;
        $this->options = $options;
        $this->selected = $selected;
        $this->id = $id ?? $name;
    }

    public function render()
    {
        return view('components.input-field-select');
    }
}
