<?php

namespace App\View\Components;

use Illuminate\View\Component;

class InputFieldTextarea extends Component
{
    public string $label;
    public string $name;
    public ?string $id;
    public $value;
    public ?int $rows;

    /**
     * @param string $label
     * @param string $name
     * @param string|null $id
     * @param string|null $value
     * @param int|null $rows
     */
    public function __construct(string $label, string $name, ?string $id = null, $value = null, ?int $rows = 2)
    {
        $this->label = $label;
        $this->name = $name;
        $this->id = $id ?? $name;
        $this->value = $value;
        $this->rows = $rows;
    }

    public function render()
    {
        return view('components.input-field-textarea');
    }
}
