<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('student_id')->unique(); // id
            $table->string('student_number')->nullable(); // number
            $table->string('student_name'); // name
            $table->float('admission_degree')->nullable();
            $table->tinyInteger('gender')->nullable()->default(0);
            
            
            $table->decimal('program_fees', 10, 2)->nullable()->default(0.0);
            $table->decimal('registration_fees', 10, 2)->nullable()->default(0.0);
            $table->decimal('insurance_fees', 10, 2)->nullable()->default(0.0);
            $table->integer('discount')->nullable()->default(0);
            
            
            $table->date('date_of_birth')->nullable();
            $table->string('phone_number')->nullable(); // phone
            $table->string('phone_number2')->nullable(); // mobile
            $table->string('email')->nullable();
            $table->string('nationality')->nullable();

            $table->string('guardian_phone_number')->nullable();
            
            $table->string('national_id')->nullable();
            $table->string('college_id')->nullable(); // faculty_id => FacultyNumber
            $table->string('program_id')->nullable();
            $table->string('section_id')->nullable(); // department_id => DepartmentNumber
            $table->string('state_id')->nullable();
            $table->string('admission_id')->nullable();
            $table->string('batch_id')->nullable();

            // will be deleted
            $table->string('addmission_type')->nullable();
            $table->timestamp('addmission_date')->nullable();
            $table->string('addmission_form_no')->nullable();
            $table->string('certificate_type')->nullable();


            $table->string('notes')->nullable();
            $table->timestamps();

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }
}
