<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegistrationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->id();
            $table->string('student_id')->unsigned()->nullable();
            $table->string('student_name')->nullable();
            $table->string('payment_reference')->nullable();
            $table->timestamp('start')->nullable();
            $table->timestamp('end')->nullable();
            $table->tinyInteger('is_paid');
            $table->decimal('study_fees', 10, 2)->nullable()->default(0.0);
            $table->decimal('registration_fees', 10, 2)->nullable()->default(0.0);
            $table->decimal('insurance_fees', 10, 2)->nullable()->default(0.0);
            $table->decimal('discount', 10, 2)->nullable()->default(0.0);
            $table->integer('semester_id')->nullable();
            $table->decimal('payment_amount', 10, 2)->nullable()->default(0.0);
            $table->decimal('due_amount', 10, 2)->nullable()->default(0.0);
            $table->integer('user_id')->unsigned()->nullable();
            $table->integer('fee_type_id')->nullable();
            $table->timestamps();

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registrations');
    }
}
