<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('student_id')->unsigned()->nullable();
            $table->string('student_name')->nullable();
            $table->string('payment_reference')->unsigned()->nullable();
            $table->integer('semester_id')->nullable();
            $table->decimal('payment_amount', 10, 2)->nullable()->default(0.0);
            $table->string('transaction_ref')->nullable();
            $table->string('bank_id')->unsigned()->nullable();
            $table->integer('fee_type_id')->nullable();
            $table->timestamps();

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
