<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFeesColumnsToPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->decimal('study_fees', 10, 2)->nullable();
            $table->decimal('registration_fees', 10, 2)->nullable();
            $table->decimal('insurance_fees', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->decimal('penalty', 10, 2)->nullable();
            $table->decimal('stamp', 10, 2)->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn('study_fees');
            $table->dropColumn('registration_fees');
            $table->dropColumn('insurance_fees');
            $table->dropColumn('discount');
            $table->dropColumn('penalty');
            $table->dropColumn('stamp');
        });
    }
}
